"""
The full documentation is avaiable here: https://docs.optimeering.no/

These are the functions available when importing __archimedes__.

Example usage:
>>> archimedes.list_ids()
...prints list of available time series
"""

from archimedes.configuration import constants  # config
from archimedes.data.api import get_predictions_api, get_api
from archimedes.data.database import (
    get,
    get_latest,
    list_ids,
    store_prediction,
    get_predictions,
    list_prediction_ids,
)
from archimedes.organizer.organizer import (
    run,
    store,
    load_latest_model,
    log,
    deploy,
    store_test_results,
    add_tag,
    set_note,
    store_model,
)
from archimedes.utils import compact_print, full_print, environ


__all__ = [
    "compact_print",
    "full_print",
    "environ",
    "get",
    "get_latest",
    "list_ids",
    "load_latest_model",
    "log",
    "run",
    "store",
    "store_prediction",
    "store_test_results",
    "deploy",
    "get_api",
    "get_predictions_api",
    "add_tag",
    "set_note",
    "get_predictions",
    "list_prediction_ids",
    "store_model",
]
