"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from ..shared import creditnotelineitem as shared_creditnotelineitem
from ..shared import creditnotetype as shared_creditnotetype
from ..shared import customerminified as shared_customerminified
from ..shared import discount as shared_discount
from ..shared import reason as shared_reason
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from orb import utils


@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class CreditNote:
    created_at: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('created_at'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""The creation time of the resource in Orb."""
    credit_note_number: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('credit_note_number') }})
    r"""The unique identifier for credit notes."""
    credit_note_pdf: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('credit_note_pdf') }})
    r"""A URL to a PDF version of this credit note."""
    customer: shared_customerminified.CustomerMinified = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('customer') }})
    r"""The customer receiving this invoice."""
    discounts: list[shared_discount.Discount] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('discounts') }})
    r"""Any discounts applied on the original invoice."""
    id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('id') }})
    r"""The unique id of this credit note."""
    invoice_id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('invoice_id') }})
    r"""The Invoice resource that this credit note is applied to."""
    line_items: list[shared_creditnotelineitem.CreditNoteLineItem] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('line_items') }})
    r"""All of the line items associated with this credit note"""
    memo: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('memo') }})
    r"""An optional memo supplied on the credit note."""
    minimum_amount_refunded: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('minimum_amount_refunded') }})
    r"""Any credited amount from the applied minimum on the invoice."""
    reason: shared_reason.Reason = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('reason') }})
    r"""A reason for this credit note, which can be one of \\"Duplicate\\", \\"Fraudulent\\", \\"Order change\\", \\"Product unsatisfactory\\" """
    subtotal: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('subtotal') }})
    r"""The total prior to any creditable invoice-level discounts or minimums"""
    total: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('total') }})
    r"""The total including creditable invoice-level discounts or minimums, and tax"""
    type: shared_creditnotetype.CreditNoteType = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('type') }})
    r"""Describing if this is an `adjustment` or a `refund`"""
    voided_at: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('voided_at'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""The time when the credit note was voided in Orb, if applicable."""
    

