"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from ..shared import discount as shared_discount
from ..shared import grouping as shared_grouping
from ..shared import sublineitem1 as shared_sublineitem1
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from orb import utils
from typing import Optional


@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class LineItemMaximumAmount:
    applies_to_price_ids: list[str] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('applies_to_price_ids') }})
    r"""List of price_ids that this maximum amount applies to. For plan/plan phase maximums, this can be a subset of prices."""
    maximum_amount: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('maximum_amount') }})
    r"""Maximum amount applied"""
    



@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class LineItemMinimumAmount:
    applies_to_price_ids: list[str] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('applies_to_price_ids') }})
    r"""List of price_ids that this minimum amount applies to. For plan/plan phase minimums, this can be a subset of prices."""
    minimum_amount: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('minimum_amount') }})
    r"""Minimum amount applied"""
    



@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class LineItem:
    amount: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('amount') }})
    r"""The final amount after any discounts or minimums."""
    discount: shared_discount.Discount = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('discount') }})
    end_date: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('end_date'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""The end date of the range of time applied for this line item's price."""
    grouping: shared_grouping.Grouping = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('grouping') }})
    r"""For configured prices that are split by a grouping key, this will be populated with the key and a value. The `amount` will be the values for this particular grouping."""
    minimum: LineItemMinimumAmount = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('minimum') }})
    name: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('name') }})
    r"""The name of the price associated with this line item."""
    quantity: float = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('quantity') }})
    start_date: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('start_date'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""The start date of the range of time applied for this line item's price."""
    sub_line_items: list[shared_sublineitem1.SubLineItem1] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('sub_line_items') }})
    r"""For complex pricing structures, the line item can be broken down further in `sub_line_items`."""
    subtotal: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('subtotal') }})
    r"""The line amount before any line item-specific discounts or minimums."""
    maximum: Optional[LineItemMaximumAmount] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('maximum'), 'exclude': lambda f: f is None }})
    

