"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
from ..shared import externalmarketplace as shared_externalmarketplace
from ..shared import phaseoverride as shared_phaseoverride
from dataclasses_json import Undefined, dataclass_json
from datetime import date
from orb import utils
from typing import Any, Optional



@dataclasses.dataclass
class NewSubscriptionMetadata:
    r"""User-specified key value pairs, often useful for referencing internal resources or IDs. Returned as-is in the subscription resource."""
    



@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class NewSubscription:
    align_billing_with_subscription_start_date: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('align_billing_with_subscription_start_date'), 'exclude': lambda f: f is None }})
    r"""Align billing periods with the subscription's start_date. If this is not provided, this defaults to aligning billing periods with the start of the month."""
    auto_collection: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('auto_collection'), 'exclude': lambda f: f is None }})
    r"""Used to determine whether Orb will attempt to automatically charge the payment method on file for the customer corresponding to this subscription. If not provided, the property on the corresponding customer will be honored."""
    coupon_redemption_code: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('coupon_redemption_code'), 'exclude': lambda f: f is None }})
    r"""Redemption code to be used for this subscription. If the coupon cannot be found by its redemption code, or cannot be redeemed, an error response will be returned and the plan change will not be scheduled."""
    customer_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('customer_id'), 'exclude': lambda f: f is None }})
    r"""The ID of the customer to subscribe."""
    default_invoice_memo: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('default_invoice_memo'), 'exclude': lambda f: f is None }})
    r"""Invoices for this subscription will populate with this memo. When not set, the plan-level setting for memo will be used."""
    external_customer_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('external_customer_id'), 'exclude': lambda f: f is None }})
    r"""The external ID of the customer to subscribe, as an alternate to passing the `customer_id`."""
    external_marketplace: Optional[shared_externalmarketplace.ExternalMarketplace] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('external_marketplace'), 'exclude': lambda f: f is None }})
    r"""Optionally provide the name of the external marketplace that the subscription is attached to."""
    external_marketplace_reporting_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('external_marketplace_reporting_id'), 'exclude': lambda f: f is None }})
    r"""The reporting ID to associate this subscription with the external marketplace. Required if external_marketplace is specified."""
    external_plan_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('external_plan_id'), 'exclude': lambda f: f is None }})
    r"""The external ID of the plan, which can be used in place of the `plan_id`."""
    maximum_amount: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('maximum_amount'), 'exclude': lambda f: f is None }})
    r"""The subscription's override maximum amount for the plan."""
    metadata: Optional[NewSubscriptionMetadata] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('metadata'), 'exclude': lambda f: f is None }})
    r"""User-specified key value pairs, often useful for referencing internal resources or IDs. Returned as-is in the subscription resource."""
    minimum_amount: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('minimum_amount'), 'exclude': lambda f: f is None }})
    r"""The subscription's override minimum amount for the plan."""
    net_terms: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('net_terms'), 'exclude': lambda f: f is None }})
    r"""The net terms of a subscription determine when a subscription's invoice is due relative to its issue date. Whereas a net terms of 0 signifies \\"due on issue\\", a net terms of 30 can be used to provide the customer one month to pay the invoice. By default, the subscription defaults to the plan's net terms configuration."""
    phase_overrides: Optional[list[shared_phaseoverride.PhaseOverride]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('phase_overrides'), 'exclude': lambda f: f is None }})
    r"""Optionally provide a list of minimum amount or discount overrides for phases on the plan."""
    plan_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('plan_id'), 'exclude': lambda f: f is None }})
    r"""The plan that the given customer should be subscribed to. The plan determines the pricing and cadence of the subscription."""
    price_overrides: Optional[list[Any]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('price_overrides'), 'exclude': lambda f: f is None }})
    r"""Optionally provide a list of overrides for prices on the plan"""
    start_date: Optional[date] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('start_date'), 'encoder': utils.dateisoformat(True), 'decoder': utils.datefromisoformat, 'exclude': lambda f: f is None }})
    r"""The date that Orb should start billing for the subscription, localized to the customer's timezone. If this is not provided, this defaults to the current date in the customer's timezone."""
    

