/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.csv;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvBindByPosition;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.TestResult;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class CsvExportBehavior
implements Serializable {
    @CsvBindByName(column="Epic")
    @CsvBindByPosition(position=0)
    private final String epic;
    @CsvBindByName(column="Feature")
    @CsvBindByPosition(position=1)
    private final String feature;
    @CsvBindByName(column="Story")
    @CsvBindByPosition(position=2)
    private final String story;
    @CsvBindByName(column="FAILED")
    @CsvBindByPosition(position=3)
    private long failed;
    @CsvBindByName(column="BROKEN")
    @CsvBindByPosition(position=4)
    private long broken;
    @CsvBindByName(column="PASSED")
    @CsvBindByPosition(position=5)
    private long passed;
    @CsvBindByName(column="SKIPPED")
    @CsvBindByPosition(position=6)
    private long skipped;
    @CsvBindByName(column="UNKNOWN")
    @CsvBindByPosition(position=7)
    private long unknown;

    public CsvExportBehavior(String epic, String feature, String story) {
        this.epic = epic;
        this.feature = feature;
        this.story = story;
    }

    public String getEpic() {
        return this.epic;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getStory() {
        return this.story;
    }

    public long getFailed() {
        return this.failed;
    }

    public long getBroken() {
        return this.broken;
    }

    public long getPassed() {
        return this.passed;
    }

    public long getSkipped() {
        return this.skipped;
    }

    public long getUnknown() {
        return this.unknown;
    }

    public boolean isPassed(String epic, String feature, String story) {
        return StringUtils.equals((CharSequence)this.epic, (CharSequence)epic) && StringUtils.equals((CharSequence)this.feature, (CharSequence)feature) && StringUtils.equals((CharSequence)this.story, (CharSequence)story);
    }

    public void addTestResult(TestResult result) {
        if (Status.FAILED.equals(result.getStatus())) {
            ++this.failed;
        }
        if (Status.BROKEN.equals(result.getStatus())) {
            ++this.broken;
        }
        if (Status.PASSED.equals(result.getStatus())) {
            ++this.passed;
        }
        if (Status.SKIPPED.equals(result.getStatus())) {
            ++this.skipped;
        }
        if (Status.UNKNOWN.equals(result.getStatus())) {
            ++this.unknown;
        }
    }
}

