import typing

T = typing.TypeVar("T")


class File(typing.TypedDict):
    date_created: str
    id: str
    is_series: bool
    name: str
    size: int
    status: int
    status_label: str
    tenant: int
    user: str
    file_type: int
    file_type_label: str


class FileMetadata(typing.TypedDict):
    file: str
    id: str
    key: str
    tenant: int
    value: str


class FilePart(typing.TypedDict):
    ETag: str
    LastModified: str
    PartNumber: int
    Size: int


class FileParts(typing.TypedDict):
    """
    API returns a list of file parts and the total upload percentage, or (None, None) in some cases.

    For example:

        {
            "parts": [
                {
                    "ETag": "\"5f363e0e58a95f06cbe9bbc662c5dfb6\"",
                    "LastModified": "2023-06-01T22:01:56Z",
                    "PartNumber": 18,
                    "Size": 5242880
                }
            ],
            "total_upload_percentage": 1
        }
    """

    parts: typing.Optional[list[FilePart]]
    total_upload_percentage: typing.Optional[int]


class FileUploadUrls(typing.TypedDict):
    MultiPartID: str
    PresignedUrls: list[str]


class Project(typing.TypedDict):
    date_created: str
    id: str
    key: str
    name: str
    short_description: str
    status: int
    status_label: str
    tenant: int
    user: str


class PaginatedResponse(typing.TypedDict, typing.Generic[T]):
    count: int
    next: typing.Optional[str]
    previous: typing.Optional[str]
    results: list[T]


class Tenant(typing.TypedDict):
    created: str
    id: int
    key: str
    name: str


class Tool(typing.TypedDict):
    key: str


class ToolVersion(typing.TypedDict):
    tool: Tool
    tool_spec: dict
    draft_tool_spec: dict
    code_file: str


class CodeFile(typing.TypedDict):
    checksum: str
    size: int


class FileDownload(typing.TypedDict):
    Url: str


class Container(typing.TypedDict):
    checksum: str
    id: int
    name: str
    repository: str
    label: str
    date_created: str
    date_updated: str
    description: str
    full_name: str
    status: int
    readme: None
    size: int
    tags: list[str]
    tenant: int
    user: str
