/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.generator.handler;

import com.javonet.core.analyzer.InterfaceAnalyzer;
import com.javonet.core.generator.handler.Handlers;
import com.javonet.core.handler.loadlibrary.JvmClassLoader;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.HandlerUtils;
import com.javonet.utils.RuntimeName;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class GeneratorHandler {
    public Command analyze(String jarPath) {
        Handlers handlers = new Handlers();
        handlers.typesToAnalyze.addAll(InterfaceAnalyzer.returnClassesFromJar(jarPath));
        Command structuredCommandForClass = new Command(RuntimeName.Jvm, CommandType.GENERATE_LIB, new Object[0]);
        while (!handlers.typesToAnalyze.isEmpty()) {
            structuredCommandForClass = structuredCommandForClass.addArgToPayload(handlers.GENERATOR_HANDLER.get((Object)CommandType.GET_TYPE).generateCommand(handlers.typesToAnalyze.poll(), structuredCommandForClass, handlers));
        }
        return structuredCommandForClass;
    }

    public ArrayList<File> generate(Command command, String filePath) {
        Handlers generatorHandlers = new Handlers();
        ArrayList<File> loadedClassFiles = new ArrayList<File>();
        for (int i = 0; i < command.getPayload().length; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            Object payloadItem = command.getPayload()[i];
            if (!(payloadItem instanceof Command)) {
                throw new IllegalArgumentException("Argument is not type of JvmCommand GetType command");
            }
            generatorHandlers.GENERATOR_HANDLER.get((Object)((Command)payloadItem).getCommandType()).generateCode(stringBuilder, command, payloadItem, generatorHandlers);
            loadedClassFiles.add(this.generateClassFile(stringBuilder, ((Command)payloadItem).getPayload()[0].toString(), filePath));
        }
        return loadedClassFiles;
    }

    public File generateOptimizedTransmitter(Command command, String filePath) {
        StringBuilder optimizedTransmitterStringBuilder = new StringBuilder();
        optimizedTransmitterStringBuilder.append("import java.util.Locale;");
        optimizedTransmitterStringBuilder.append(System.getProperty("line.separator"));
        optimizedTransmitterStringBuilder.append("import com.javonet.core.generator.IOptimizedTransmitter;");
        optimizedTransmitterStringBuilder.append(System.getProperty("line.separator"));
        optimizedTransmitterStringBuilder.append("public class JvmOptimizedTransmitter implements IOptimizedTransmitter {");
        optimizedTransmitterStringBuilder.append(System.getProperty("line.separator"));
        optimizedTransmitterStringBuilder.append("public JvmOptimizedTransmitter(){}");
        optimizedTransmitterStringBuilder.append(System.getProperty("line.separator"));
        optimizedTransmitterStringBuilder.append("static { String dir = System.getProperty(\"user.dir\");\n        if (System.getProperty(\"os.name\").toLowerCase(Locale.ROOT).contains(\"win\")) {\n            System.load(dir + \"\\\\Binaries\\\\Native\\\\Windows\\\\X64\\\\").append(command.getPayload()[0].toString()).append(".dll\");\n").append("} else if (System.getProperty(\"os.name\").toLowerCase(Locale.ROOT).contains(\"mac\")) {\n").append("            System.load(dir + \"/Binaries/Native/MacOs/X64/lib").append(command.getPayload()[0].toString()).append(".dylib\");\n").append("        } else {\n").append("            System.load(dir + \"/Binaries/Native/Linux/X64/lib").append(command.getPayload()[0].toString()).append(".so\");\n").append("        }\n}");
        optimizedTransmitterStringBuilder.append(System.getProperty("line.separator"));
        optimizedTransmitterStringBuilder.append("public static native int method(int var0);");
        optimizedTransmitterStringBuilder.append(System.getProperty("line.separator"));
        optimizedTransmitterStringBuilder.append("public Object execute(Object[] var1) {\n        return method((Integer)var1[0]);\n    }");
        optimizedTransmitterStringBuilder.append(System.getProperty("line.separator"));
        optimizedTransmitterStringBuilder.append("}");
        return this.generateClassFile(optimizedTransmitterStringBuilder, "JvmOptimizedTransmitter", filePath);
    }

    public void compileClass(File myGeneratedFileClass) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        compiler.run(null, null, null, myGeneratedFileClass.getPath());
    }

    public static Class<?> getClass(String className, File userLocation) {
        Class<?> loadedClass = null;
        try {
            JvmClassLoader jvmClassLoader = new JvmClassLoader(new URL[0], GeneratorHandler.class.getClassLoader());
            jvmClassLoader.addUrl(userLocation.toURI().toURL());
            loadedClass = jvmClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            e.printStackTrace();
        }
        return loadedClass;
    }

    public Class<?> getClassFromUrl(String className, File classPath) {
        Class<?> loadedClass = null;
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{classPath.toURI().toURL()});
            loadedClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            e.printStackTrace();
        }
        return loadedClass;
    }

    public Object getClassObject(Class<?> compiledClass, Object ... constructorArguments) {
        try {
            if (constructorArguments.length == 0) {
                try {
                    return compiledClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            try {
                Class<?>[] argumentTypes = HandlerUtils.getArgumentTypes(constructorArguments);
                Constructor<?> constructor = compiledClass.getConstructor(argumentTypes);
                return constructor.newInstance(constructorArguments);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                System.out.println("EXCEPTION CAUSE: " + e.getCause().toString());
                throw e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e;
        }
    }

    private File generateClassFile(StringBuilder classStringBuilder, String classFileName, String filePath) {
        String directoryPath = GeneratorHandler.generatePackageFileLocation(classFileName, filePath);
        String javaFilePath = directoryPath + File.separator + GeneratorHandler.getClassNameWithoutPackage(classFileName) + ".java";
        File myObj = new File(javaFilePath);
        try {
            if (myObj.createNewFile()) {
                System.out.println("File created: " + myObj.getName());
            } else {
                System.out.println("File already exists.");
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(myObj));){
                writer.write(classStringBuilder.toString());
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return myObj;
    }

    private static String generatePackageFileLocation(String classFileName, String filePath) {
        String fileLocation = GeneratorHandler.packageNameToFileLocation(GeneratorHandler.getPackageName(classFileName));
        File directory = new File(filePath + fileLocation + File.separator);
        if (!directory.exists()) {
            boolean bl = directory.mkdirs();
        }
        return directory.toString();
    }

    private static String packageNameToFileLocation(String name) {
        if (name.contains(".")) {
            return System.getProperty("file.separator") + name.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        }
        if (name.isEmpty()) {
            return "";
        }
        return System.getProperty("file.separator") + name;
    }

    private static String fileNameToClassName(String fileName) {
        if (fileName.contains(".")) {
            return fileName.split("\\.")[0];
        }
        return fileName;
    }

    public static String getPackageName(String className) {
        if (className.contains(".")) {
            return className.substring(0, className.lastIndexOf("."));
        }
        return "";
    }

    public static String getClassNameWithoutPackage(String className) {
        return className.split("\\.")[className.split("\\.").length - 1];
    }
}

