/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Field;

public class SetStaticFieldHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 3;

    @Override
    public Object process(Command command) throws Exception {
        if (command.getPayload().length < 3) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 3);
        }
        Class classToLoad = (Class)command.getPayload()[0];
        String fieldName = (String)command.getPayload()[1];
        Object newValue = command.getPayload()[2];
        try {
            Field field = classToLoad.getField(fieldName);
            field.set(null, newValue);
        }
        catch (NoSuchFieldException e) {
            Field[] fields = classToLoad.getFields();
            StringBuilder message = new StringBuilder("Field " + fieldName + " not found in class " + classToLoad.getName() + ". Available fields:\n");
            for (Field field : fields) {
                message.append(field.getName()).append("\n");
            }
            throw new NoSuchFieldException(message.toString());
        }
        return 0;
    }
}

