# coding: utf-8

"""
Binance Derivatives Trading Options WebSocket Market Streams

OpenAPI Specification for the Binance Derivatives Trading Options WebSocket Market Streams
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class Ticker24HourResponse(BaseModel):
    """
    Ticker24HourResponse
    """  # noqa: E501

    e: Optional[StrictStr] = None
    E: Optional[StrictInt] = Field(default=None, alias="E")
    T: Optional[StrictInt] = Field(default=None, alias="T")
    s: Optional[StrictStr] = None
    o: Optional[StrictStr] = None
    h: Optional[StrictStr] = None
    l: Optional[StrictStr] = None
    c: Optional[StrictStr] = None
    V: Optional[StrictStr] = Field(default=None, alias="V")
    A: Optional[StrictStr] = Field(default=None, alias="A")
    P: Optional[StrictStr] = Field(default=None, alias="P")
    p: Optional[StrictStr] = None
    Q: Optional[StrictStr] = Field(default=None, alias="Q")
    F: Optional[StrictStr] = Field(default=None, alias="F")
    L: Optional[StrictStr] = Field(default=None, alias="L")
    n: Optional[StrictInt] = None
    bo: Optional[StrictStr] = None
    ao: Optional[StrictStr] = None
    bq: Optional[StrictStr] = None
    aq: Optional[StrictStr] = None
    b: Optional[StrictStr] = None
    a: Optional[StrictStr] = None
    d: Optional[StrictStr] = None
    t: Optional[StrictStr] = None
    g: Optional[StrictStr] = None
    v: Optional[StrictStr] = None
    vo: Optional[StrictStr] = None
    mp: Optional[StrictStr] = None
    hl: Optional[StrictStr] = None
    ll: Optional[StrictStr] = None
    eep: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "e",
        "E",
        "T",
        "s",
        "o",
        "h",
        "l",
        "c",
        "V",
        "A",
        "P",
        "p",
        "Q",
        "F",
        "L",
        "n",
        "bo",
        "ao",
        "bq",
        "aq",
        "b",
        "a",
        "d",
        "t",
        "g",
        "v",
        "vo",
        "mp",
        "hl",
        "ll",
        "eep",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Ticker24HourResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Ticker24HourResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "e": obj.get("e"),
                "E": obj.get("E"),
                "T": obj.get("T"),
                "s": obj.get("s"),
                "o": obj.get("o"),
                "h": obj.get("h"),
                "l": obj.get("l"),
                "c": obj.get("c"),
                "V": obj.get("V"),
                "A": obj.get("A"),
                "P": obj.get("P"),
                "p": obj.get("p"),
                "Q": obj.get("Q"),
                "F": obj.get("F"),
                "L": obj.get("L"),
                "n": obj.get("n"),
                "bo": obj.get("bo"),
                "ao": obj.get("ao"),
                "bq": obj.get("bq"),
                "aq": obj.get("aq"),
                "b": obj.get("b"),
                "a": obj.get("a"),
                "d": obj.get("d"),
                "t": obj.get("t"),
                "g": obj.get("g"),
                "v": obj.get("v"),
                "vo": obj.get("vo"),
                "mp": obj.get("mp"),
                "hl": obj.get("hl"),
                "ll": obj.get("ll"),
                "eep": obj.get("eep"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
