# coding: utf-8

"""
Binance Derivatives Trading Options WebSocket Market Streams

OpenAPI Specification for the Binance Derivatives Trading Options WebSocket Market Streams
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import json
import pprint
from pydantic import (
    BaseModel,
    ConfigDict,
    ValidationError,
    field_validator,
)
from typing import Any, Optional
from binance_sdk_derivatives_trading_options.websocket_streams.models.account_update import (
    AccountUpdate,
)
from binance_sdk_derivatives_trading_options.websocket_streams.models.order_trade_update import (
    OrderTradeUpdate,
)
from binance_sdk_derivatives_trading_options.websocket_streams.models.risk_level_change import (
    RiskLevelChange,
)
from typing import Union, Set, Dict
from typing_extensions import Self

USERDATASTREAMEVENTSRESPONSE_ONE_OF_SCHEMAS = [
    "AccountUpdate",
    "OrderTradeUpdate",
    "RiskLevelChange",
]


class UserDataStreamEventsResponse(BaseModel):
    """
    UserDataStreamEventsResponse
    """

    # data type: AccountUpdate
    oneof_schema_1_validator: Optional[AccountUpdate] = None
    # data type: OrderTradeUpdate
    oneof_schema_2_validator: Optional[OrderTradeUpdate] = None
    # data type: RiskLevelChange
    oneof_schema_3_validator: Optional[RiskLevelChange] = None
    actual_instance: Optional[
        Union[AccountUpdate, OrderTradeUpdate, RiskLevelChange]
    ] = None
    one_of_schemas: Set[str] = {"AccountUpdate", "OrderTradeUpdate", "RiskLevelChange"}

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    discriminator_value_class_map: Dict[str, str] = {}

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):

        error_messages = []
        match = 0
        # validate data type: AccountUpdate
        if not isinstance(v, AccountUpdate):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `AccountUpdate`"
            )
        else:
            match += 1
        # validate data type: OrderTradeUpdate
        if not isinstance(v, OrderTradeUpdate):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `OrderTradeUpdate`"
            )
        else:
            match += 1
        # validate data type: RiskLevelChange
        if not isinstance(v, RiskLevelChange):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `RiskLevelChange`"
            )
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in UserDataStreamEventsResponse with oneOf schemas: AccountUpdate, OrderTradeUpdate, RiskLevelChange. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in UserDataStreamEventsResponse with oneOf schemas: AccountUpdate, OrderTradeUpdate, RiskLevelChange. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into AccountUpdate
        try:
            instance.actual_instance = AccountUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into OrderTradeUpdate
        try:
            instance.actual_instance = OrderTradeUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RiskLevelChange
        try:
            instance.actual_instance = RiskLevelChange.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into UserDataStreamEventsResponse with oneOf schemas: AccountUpdate, OrderTradeUpdate, RiskLevelChange. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into UserDataStreamEventsResponse with oneOf schemas: AccountUpdate, OrderTradeUpdate, RiskLevelChange. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(
            self.actual_instance.to_json
        ):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[
        Union[Dict[str, Any], AccountUpdate, OrderTradeUpdate, RiskLevelChange]
    ]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(
            self.actual_instance.to_dict
        ):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
