# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ConnectionKeysArgs', 'ConnectionKeys']

@pulumi.input_type
class ConnectionKeysArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[_builtins.str],
                 triggers: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a ConnectionKeys resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: This is an arbitrary map, which when edited shall perform rotation of keys for the corresponding connection. It can host keys like version, timestamp of last rotation etc.The field has no association with API
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_id", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        This is an arbitrary map, which when edited shall perform rotation of keys for the corresponding connection. It can host keys like version, timestamp of last rotation etc.The field has no association with API
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "triggers", value)


@pulumi.input_type
class _ConnectionKeysState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 current: Optional[pulumi.Input[_builtins.bool]] = None,
                 current_since: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 key_use: Optional[pulumi.Input[_builtins.str]] = None,
                 kid: Optional[pulumi.Input[_builtins.str]] = None,
                 next: Optional[pulumi.Input[_builtins.bool]] = None,
                 pkcs: Optional[pulumi.Input[_builtins.str]] = None,
                 previous: Optional[pulumi.Input[_builtins.bool]] = None,
                 subject_dn: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ConnectionKeys resources.
        :param pulumi.Input[_builtins.str] algorithm: The signing key algorithm.
        :param pulumi.Input[_builtins.str] cert: The public certificate of the signing key.
        :param pulumi.Input[_builtins.bool] current: True if the key is the current key.
        :param pulumi.Input[_builtins.str] current_since: The date and time when the key became the current key.
        :param pulumi.Input[_builtins.str] fingerprint: The certificate fingerprint.
        :param pulumi.Input[_builtins.str] key_use: The signing key use, whether for encryption or signing.
        :param pulumi.Input[_builtins.str] kid: The key ID of the signing key.
        :param pulumi.Input[_builtins.bool] next: True if the key is the next key.
        :param pulumi.Input[_builtins.str] pkcs: The public certificate of the signing key in PKCS7 format.
        :param pulumi.Input[_builtins.bool] previous: True if the key is the previous key.
        :param pulumi.Input[_builtins.str] subject_dn: The subject distinguished name (DN) of the certificate.
        :param pulumi.Input[_builtins.str] thumbprint: The certificate thumbprint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: This is an arbitrary map, which when edited shall perform rotation of keys for the corresponding connection. It can host keys like version, timestamp of last rotation etc.The field has no association with API
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if current is not None:
            pulumi.set(__self__, "current", current)
        if current_since is not None:
            pulumi.set(__self__, "current_since", current_since)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if key_use is not None:
            pulumi.set(__self__, "key_use", key_use)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if next is not None:
            pulumi.set(__self__, "next", next)
        if pkcs is not None:
            pulumi.set(__self__, "pkcs", pkcs)
        if previous is not None:
            pulumi.set(__self__, "previous", previous)
        if subject_dn is not None:
            pulumi.set(__self__, "subject_dn", subject_dn)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signing key algorithm.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public certificate of the signing key.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @_builtins.property
    @pulumi.getter
    def current(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the key is the current key.
        """
        return pulumi.get(self, "current")

    @current.setter
    def current(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "current", value)

    @_builtins.property
    @pulumi.getter(name="currentSince")
    def current_since(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the key became the current key.
        """
        return pulumi.get(self, "current_since")

    @current_since.setter
    def current_since(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_since", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="keyUse")
    def key_use(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signing key use, whether for encryption or signing.
        """
        return pulumi.get(self, "key_use")

    @key_use.setter
    def key_use(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_use", value)

    @_builtins.property
    @pulumi.getter
    def kid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key ID of the signing key.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kid", value)

    @_builtins.property
    @pulumi.getter
    def next(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the key is the next key.
        """
        return pulumi.get(self, "next")

    @next.setter
    def next(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "next", value)

    @_builtins.property
    @pulumi.getter
    def pkcs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public certificate of the signing key in PKCS7 format.
        """
        return pulumi.get(self, "pkcs")

    @pkcs.setter
    def pkcs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pkcs", value)

    @_builtins.property
    @pulumi.getter
    def previous(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the key is the previous key.
        """
        return pulumi.get(self, "previous")

    @previous.setter
    def previous(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "previous", value)

    @_builtins.property
    @pulumi.getter(name="subjectDn")
    def subject_dn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subject distinguished name (DN) of the certificate.
        """
        return pulumi.get(self, "subject_dn")

    @subject_dn.setter
    def subject_dn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_dn", value)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thumbprint", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        This is an arbitrary map, which when edited shall perform rotation of keys for the corresponding connection. It can host keys like version, timestamp of last rotation etc.The field has no association with API
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "triggers", value)


@pulumi.type_token("auth0:index/connectionKeys:ConnectionKeys")
class ConnectionKeys(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Client Assertion JWT is a more secure alternative to client secret authentication for OIDC and Okta Workforce connections. It uses a signed JWT instead of a shared secret to authenticate the client. The resource only supports key rotation. Use the ConnectionKeys data source to read existing keys. Removing the resource from configuration will NOT DELETE the key.

        !> The triggers field is only a placeholder for an arbitrary map used to signal the provider
        to perform a key rotation whenever any update is made.
        If the resource is removed from the configuration, the keys will not be deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_client = auth0.Client("my_client", name="My-Auth0-Client")
        oidc = auth0.Connection("oidc",
            name="OIDC-Connection",
            strategy="oidc",
            options={
                "client_id": my_client.id,
                "scopes": [
                    "ext_nested_groups",
                    "openid",
                ],
                "issuer": "https://example.com",
                "authorization_endpoint": "https://example.com",
                "jwks_uri": "https://example.com/jwks",
                "type": "front_channel",
                "discovery_url": "https://www.paypalobjects.com/.well-known/openid-configuration",
                "token_endpoint_auth_method": "private_key_jwt",
                "token_endpoint_auth_signing_alg": "RS256",
            })
        # Resource used to rotate the keys for above OIDC connection
        my_keys = auth0.ConnectionKeys("my_keys",
            connection_id=oidc.id,
            triggers={
                "version": "1",
                "date": "2023-10-01T00:00:00Z",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: This is an arbitrary map, which when edited shall perform rotation of keys for the corresponding connection. It can host keys like version, timestamp of last rotation etc.The field has no association with API
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionKeysArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Client Assertion JWT is a more secure alternative to client secret authentication for OIDC and Okta Workforce connections. It uses a signed JWT instead of a shared secret to authenticate the client. The resource only supports key rotation. Use the ConnectionKeys data source to read existing keys. Removing the resource from configuration will NOT DELETE the key.

        !> The triggers field is only a placeholder for an arbitrary map used to signal the provider
        to perform a key rotation whenever any update is made.
        If the resource is removed from the configuration, the keys will not be deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_client = auth0.Client("my_client", name="My-Auth0-Client")
        oidc = auth0.Connection("oidc",
            name="OIDC-Connection",
            strategy="oidc",
            options={
                "client_id": my_client.id,
                "scopes": [
                    "ext_nested_groups",
                    "openid",
                ],
                "issuer": "https://example.com",
                "authorization_endpoint": "https://example.com",
                "jwks_uri": "https://example.com/jwks",
                "type": "front_channel",
                "discovery_url": "https://www.paypalobjects.com/.well-known/openid-configuration",
                "token_endpoint_auth_method": "private_key_jwt",
                "token_endpoint_auth_signing_alg": "RS256",
            })
        # Resource used to rotate the keys for above OIDC connection
        my_keys = auth0.ConnectionKeys("my_keys",
            connection_id=oidc.id,
            triggers={
                "version": "1",
                "date": "2023-10-01T00:00:00Z",
            })
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionKeysArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionKeysArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionKeysArgs.__new__(ConnectionKeysArgs)

            if connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_id'")
            __props__.__dict__["connection_id"] = connection_id
            if triggers is None and not opts.urn:
                raise TypeError("Missing required property 'triggers'")
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["algorithm"] = None
            __props__.__dict__["cert"] = None
            __props__.__dict__["current"] = None
            __props__.__dict__["current_since"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["key_use"] = None
            __props__.__dict__["kid"] = None
            __props__.__dict__["next"] = None
            __props__.__dict__["pkcs"] = None
            __props__.__dict__["previous"] = None
            __props__.__dict__["subject_dn"] = None
            __props__.__dict__["thumbprint"] = None
        super(ConnectionKeys, __self__).__init__(
            'auth0:index/connectionKeys:ConnectionKeys',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            cert: Optional[pulumi.Input[_builtins.str]] = None,
            connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            current: Optional[pulumi.Input[_builtins.bool]] = None,
            current_since: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            key_use: Optional[pulumi.Input[_builtins.str]] = None,
            kid: Optional[pulumi.Input[_builtins.str]] = None,
            next: Optional[pulumi.Input[_builtins.bool]] = None,
            pkcs: Optional[pulumi.Input[_builtins.str]] = None,
            previous: Optional[pulumi.Input[_builtins.bool]] = None,
            subject_dn: Optional[pulumi.Input[_builtins.str]] = None,
            thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
            triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ConnectionKeys':
        """
        Get an existing ConnectionKeys resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: The signing key algorithm.
        :param pulumi.Input[_builtins.str] cert: The public certificate of the signing key.
        :param pulumi.Input[_builtins.bool] current: True if the key is the current key.
        :param pulumi.Input[_builtins.str] current_since: The date and time when the key became the current key.
        :param pulumi.Input[_builtins.str] fingerprint: The certificate fingerprint.
        :param pulumi.Input[_builtins.str] key_use: The signing key use, whether for encryption or signing.
        :param pulumi.Input[_builtins.str] kid: The key ID of the signing key.
        :param pulumi.Input[_builtins.bool] next: True if the key is the next key.
        :param pulumi.Input[_builtins.str] pkcs: The public certificate of the signing key in PKCS7 format.
        :param pulumi.Input[_builtins.bool] previous: True if the key is the previous key.
        :param pulumi.Input[_builtins.str] subject_dn: The subject distinguished name (DN) of the certificate.
        :param pulumi.Input[_builtins.str] thumbprint: The certificate thumbprint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: This is an arbitrary map, which when edited shall perform rotation of keys for the corresponding connection. It can host keys like version, timestamp of last rotation etc.The field has no association with API
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionKeysState.__new__(_ConnectionKeysState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["cert"] = cert
        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["current"] = current
        __props__.__dict__["current_since"] = current_since
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["key_use"] = key_use
        __props__.__dict__["kid"] = kid
        __props__.__dict__["next"] = next
        __props__.__dict__["pkcs"] = pkcs
        __props__.__dict__["previous"] = previous
        __props__.__dict__["subject_dn"] = subject_dn
        __props__.__dict__["thumbprint"] = thumbprint
        __props__.__dict__["triggers"] = triggers
        return ConnectionKeys(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The signing key algorithm.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def cert(self) -> pulumi.Output[_builtins.str]:
        """
        The public certificate of the signing key.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter
    def current(self) -> pulumi.Output[_builtins.bool]:
        """
        True if the key is the current key.
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter(name="currentSince")
    def current_since(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the key became the current key.
        """
        return pulumi.get(self, "current_since")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="keyUse")
    def key_use(self) -> pulumi.Output[_builtins.str]:
        """
        The signing key use, whether for encryption or signing.
        """
        return pulumi.get(self, "key_use")

    @_builtins.property
    @pulumi.getter
    def kid(self) -> pulumi.Output[_builtins.str]:
        """
        The key ID of the signing key.
        """
        return pulumi.get(self, "kid")

    @_builtins.property
    @pulumi.getter
    def next(self) -> pulumi.Output[_builtins.bool]:
        """
        True if the key is the next key.
        """
        return pulumi.get(self, "next")

    @_builtins.property
    @pulumi.getter
    def pkcs(self) -> pulumi.Output[_builtins.str]:
        """
        The public certificate of the signing key in PKCS7 format.
        """
        return pulumi.get(self, "pkcs")

    @_builtins.property
    @pulumi.getter
    def previous(self) -> pulumi.Output[_builtins.bool]:
        """
        True if the key is the previous key.
        """
        return pulumi.get(self, "previous")

    @_builtins.property
    @pulumi.getter(name="subjectDn")
    def subject_dn(self) -> pulumi.Output[_builtins.str]:
        """
        The subject distinguished name (DN) of the certificate.
        """
        return pulumi.get(self, "subject_dn")

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        This is an arbitrary map, which when edited shall perform rotation of keys for the corresponding connection. It can host keys like version, timestamp of last rotation etc.The field has no association with API
        """
        return pulumi.get(self, "triggers")

