"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class AlbToLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckAlbProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: props.publicApi ? {} : { enableDnsHostnames: true, enableDnsSupport: true }
        });
        this.loadBalancer = defaults.ObtainAlb(this, id, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        // Obtain Lambda function for construct (existing or created)
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc,
        });
        let newListener;
        if (this.loadBalancer.listeners.length === 0) {
            newListener = true;
        }
        else {
            newListener = false;
        }
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_1.GetActiveListener(this.loadBalancer.listeners);
        }
        const newTargetGroup = defaults.AddLambdaTarget(this, `tg${this.loadBalancer.listeners.length + 1}`, this.listener, this.lambdaFunction, props.ruleProps, props.targetProps);
        // this.listener needs to be set on the construct.
        // could be above: else { defaults.GetActiveListener }
        // do we then move that funcionality back into the construct (not the function). If so do
        // we leave it in AddNewTarget or just do it here and pass the listener?
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependency(cfnTargetGroup);
        }
    }
}
exports.AlbToLambda = AlbToLambda;
_a = JSII_RTTI_SYMBOL_1;
AlbToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-alb-lambda.AlbToLambda", version: "2.36.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWlCQSwyQ0FBdUM7QUFDdkMsMkRBQTJEO0FBRTNELHlEQUFtRTtBQStGbkUsTUFBYSxXQUFZLFNBQVEsc0JBQVM7SUFNeEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF1QjtRQUMvRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLFFBQVEsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDM0IsUUFBUSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUU5QixpREFBaUQ7UUFDakQsSUFBSSxDQUFDLEdBQUcsR0FBRyxRQUFRLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRTtZQUNsQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsZUFBZSxFQUFFLEtBQUssQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyw0QkFBNEIsRUFBRSxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsdUJBQXVCLEVBQUU7WUFDL0csWUFBWSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQzVCLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxrQkFBa0IsRUFBRSxJQUFJLEVBQUUsZ0JBQWdCLEVBQUUsSUFBSSxFQUFFO1NBQy9GLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLEdBQUcsUUFBUSxDQUFDLFNBQVMsQ0FDcEMsSUFBSSxFQUNKLEVBQUUsRUFDRixJQUFJLENBQUMsR0FBRyxFQUNSLEtBQUssQ0FBQyxTQUFTLEVBQ2YsS0FBSyxDQUFDLHVCQUF1QixFQUM3QixLQUFLLENBQUMsaUJBQWlCLEVBQ3ZCLEtBQUssQ0FBQyxnQkFBZ0IsRUFDdEIsS0FBSyxDQUFDLHFCQUFxQixDQUM1QixDQUFDO1FBRUYsNkRBQTZEO1FBQzdELElBQUksQ0FBQyxjQUFjLEdBQUcsUUFBUSxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRTtZQUN2RCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxtQkFBbUI7WUFDOUMsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO1NBQ2QsQ0FBQyxDQUFDO1FBRUgsSUFBSSxXQUFvQixDQUFDO1FBQ3pCLElBQUksSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUM1QyxXQUFXLEdBQUcsSUFBSSxDQUFDO1NBQ3BCO2FBQU07WUFDTCxXQUFXLEdBQUcsS0FBSyxDQUFDO1NBQ3JCO1FBRUQsK0NBQStDO1FBQy9DLElBQUksV0FBVyxFQUFFO1lBQ2YsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUMsV0FBVyxDQUNsQyxJQUFJLEVBQ0osRUFBRSxFQUNGLElBQUksQ0FBQyxZQUFZLEVBQ2pCLEtBQUssQ0FBQyxhQUFhLENBQ3BCLENBQUM7U0FDSDthQUFNO1lBQ0wsSUFBSSxDQUFDLFFBQVEsR0FBRyx3QkFBaUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1NBQ2hFO1FBRUQsTUFBTSxjQUFjLEdBQUcsUUFBUSxDQUFDLGVBQWUsQ0FDN0MsSUFBSSxFQUNKLEtBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxFQUM3QyxJQUFJLENBQUMsUUFBUSxFQUNiLElBQUksQ0FBQyxjQUFjLEVBQ25CLEtBQUssQ0FBQyxTQUFTLEVBQ2YsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBRXJCLGtEQUFrRDtRQUNsRCxzREFBc0Q7UUFDdEQseUZBQXlGO1FBQ3pGLHdFQUF3RTtRQUN4RSxJQUFJLFdBQVcsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFO1lBQ2hDLE1BQU0sZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBMkIsQ0FBQztZQUN4RSxNQUFNLGNBQWMsR0FBRyxjQUFjLENBQUMsSUFBSSxDQUFDLFlBQThCLENBQUM7WUFDMUUsZ0JBQWdCLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1NBQ2hEO0lBRUgsQ0FBQzs7QUExRUgsa0NBMkVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgZWxiIGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtZWxhc3RpY2xvYWRiYWxhbmNpbmd2MlwiO1xuaW1wb3J0ICogYXMgZWMyIGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtZWMyXCI7XG5pbXBvcnQgKiBhcyBzMyBmcm9tIFwiYXdzLWNkay1saWIvYXdzLXMzXCI7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSBcImF3cy1jZGstbGliL2F3cy1sYW1iZGFcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgKiBhcyBkZWZhdWx0cyBmcm9tIFwiQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9jb3JlXCI7XG5pbXBvcnQgeyBDZm5MaXN0ZW5lciwgQ2ZuVGFyZ2V0R3JvdXAgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5ndjJcIjtcbmltcG9ydCB7IEdldEFjdGl2ZUxpc3RlbmVyIH0gZnJvbSBcIkBhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZVwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIEFsYlRvTGFtYmRhUHJvcHMge1xuICAvKipcbiAgICogT3B0aW9uYWwgY3VzdG9tIHByb3BlcnRpZXMgZm9yIGEgbmV3IGxvYWRCYWxhbmNlci4gUHJvdmlkaW5nIGJvdGggdGhpcyBhbmRcbiAgICogZXhpc3RpbmdMb2FkQmFsYW5jZXIgaXMgYW4gZXJyb3IuIFRoaXMgY2Fubm90IHNwZWNpZnkgYSBWUEMsIGl0IHdpbGwgdXNlIHRoZSBWUENcbiAgICogaW4gZXhpc3RpbmdWcGMgb3IgdGhlIFZQQyBjcmVhdGVkIGJ5IHRoZSBjb25zdHJ1Y3QuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgbG9hZEJhbGFuY2VyUHJvcHM/OiBlbGIuQXBwbGljYXRpb25Mb2FkQmFsYW5jZXJQcm9wcyB8IGFueTtcbiAgLyoqXG4gICAqIEV4aXN0aW5nIEFwcGxpY2F0aW9uIExvYWQgQmFsYW5jZXIgdG8gaW5jb3Jwb3JhdGUgaW50byB0aGVcbiAgICogY29uc3RydWN0IGFyY2hpdGVjdHVyZS4gUHJvdmlkaW5nIGJvdGggdGhpcyBhbmQgbG9hZEJhbGFuY2VyUHJvcHMgaXMgYW5cbiAgICogZXJyb3IuIFRoZSBWUEMgY29udGFpbmluZyB0aGlzIGxvYWRCYWxhbmNlciBtdXN0IG1hdGNoIHRoZSBWUEMgcHJvdmlkZWQgaW4gZXhpc3RpbmdWcGMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZXhpc3RpbmdMb2FkQmFsYW5jZXJPYmo/OiBlbGIuQXBwbGljYXRpb25Mb2FkQmFsYW5jZXI7XG4gIC8qKlxuICAgKiBFeGlzdGluZyBpbnN0YW5jZSBvZiBMYW1iZGEgRnVuY3Rpb24gb2JqZWN0LCBwcm92aWRpbmcgYm90aCB0aGlzIGFuZFxuICAgKiBgbGFtYmRhRnVuY3Rpb25Qcm9wc2Agd2lsbCBjYXVzZSBhbiBlcnJvci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ0xhbWJkYU9iaj86IGxhbWJkYS5GdW5jdGlvbjtcbiAgLyoqXG4gICAqIFVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBMYW1iZGEgZnVuY3Rpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgbGFtYmRhRnVuY3Rpb25Qcm9wcz86IGxhbWJkYS5GdW5jdGlvblByb3BzO1xuICAvKipcbiAgICogUHJvcHMgdG8gZGVmaW5lIHRoZSBsaXN0ZW5lci4gTXVzdCBiZSBwcm92aWRlZCB3aGVuIGFkZGluZyB0aGUgbGlzdGVuZXJcbiAgICogdG8gYW4gQUxCIChlZyAtIHdoZW4gY3JlYXRpbmcgdGhlIGFsYiksIG1heSBub3QgYmUgcHJvdmlkZWQgd2hlbiBhZGRpbmdcbiAgICogYSBzZWNvbmQgdGFyZ2V0IHRvIGFuIGFscmVhZHkgZXN0YWJsaXNoZWQgbGlzdGVuZXIuIFdoZW4gcHJvdmlkZWQsIG11c3QgaW5jbHVkZVxuICAgKiBlaXRoZXIgYSBjZXJ0aWZpY2F0ZSBvciBwcm90b2NvbDogSFRUUFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGxpc3RlbmVyUHJvcHM/OiBlbGIuQXBwbGljYXRpb25MaXN0ZW5lclByb3BzIHwgYW55O1xuICAvKipcbiAgICogT3B0aW9uYWwgY3VzdG9tIHByb3BlcnRpZXMgZm9yIGEgbmV3IHRhcmdldCBncm91cC4gV2hpbGUgdGhpcyBpcyBhIHN0YW5kYXJkXG4gICAqIGF0dHJpYnV0ZSBvZiBwcm9wcyBmb3IgQUxCIGNvbnN0cnVjdHMsIHRoZXJlIGFyZSBmZXcgcGVydGluZW50IHByb3BlcnRpZXMgZm9yIGEgTGFtYmRhIHRhcmdldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqXG4gICAqL1xuICByZWFkb25seSB0YXJnZXRQcm9wcz86IGVsYi5BcHBsaWNhdGlvblRhcmdldEdyb3VwUHJvcHM7XG4gIC8qKlxuICAgKiBSdWxlcyBmb3IgZGlyZWN0aW5nIHRyYWZmaWMgdG8gdGhlIHRhcmdldCBiZWluZyBjcmVhdGVkLiBNYXkgbm90IGJlIHNwZWNpZmllZFxuICAgKiBmb3IgdGhlIGZpcnN0IGxpc3RlbmVyIGFkZGVkIHRvIGFuIEFMQiwgYW5kIG11c3QgYmUgc3BlY2lmaWVkIGZvciB0aGUgc2Vjb25kXG4gICAqIHRhcmdldCBhZGRlZCB0byBhIGxpc3RlbmVyLiBBZGQgYSBzZWNvbmQgdGFyZ2V0IGJ5IGluc3RhbnRpYXRpbmcgdGhpcyBjb25zdHJ1Y3QgYVxuICAgKiBzZWNvbmQgdGltZSBhbmQgcHJvdmlkaW5nIHRoZSBleGlzdGluZ0FsYiBmcm9tIHRoZSBmaXJzdCBpbnN0YW50aWF0aW9uLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHJ1bGVQcm9wcz86IGVsYi5BZGRSdWxlUHJvcHM7XG4gIC8qKlxuICAgKiBPcHRpb25hbCBjdXN0b20gcHJvcGVydGllcyBmb3IgYSBWUEMgdGhlIGNvbnN0cnVjdCB3aWxsIGNyZWF0ZS4gVGhpcyBWUEMgd2lsbFxuICAgKiBiZSB1c2VkIGJ5IHRoZSBuZXcgQUxCIGFuZCBhbnkgUHJpdmF0ZSBIb3N0ZWQgWm9uZSB0aGUgY29uc3RydWN0IGNyZWF0ZXMgKHRoYXQnc1xuICAgKiB3aHkgbG9hZEJhbGFuY2VyUHJvcHMgYW5kIHByaXZhdGVIb3N0ZWRab25lUHJvcHMgY2FuJ3QgaW5jbHVkZSBhIFZQQykuIFByb3ZpZGluZ1xuICAgKiBib3RoIHRoaXMgYW5kIGV4aXN0aW5nVnBjIGlzIGFuIGVycm9yLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHZwY1Byb3BzPzogZWMyLlZwY1Byb3BzO1xuICAvKipcbiAgICogQW4gZXhpc3RpbmcgVlBDIGluIHdoaWNoIHRvIGRlcGxveSB0aGUgY29uc3RydWN0LiBQcm92aWRpbmcgYm90aCB0aGlzIGFuZFxuICAgKiB2cGNQcm9wcyBpcyBhbiBlcnJvci4gSWYgdGhlIGNsaWVudCBwcm92aWRlcyBhbiBleGlzdGluZyBsb2FkIGJhbGFuY2VyIGFuZC9vclxuICAgKiBleGlzdGluZyBQcml2YXRlIEhvc3RlZCBab25lLCB0aG9zZSBjb25zdHJ1Y3RzIG11c3QgZXhpc3QgaW4gdGhpcyBWUEMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZXhpc3RpbmdWcGM/OiBlYzIuSVZwYztcbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gdHVybiBvbiBBY2Nlc3MgTG9ncyBmb3IgdGhlIEFwcGxpY2F0aW9uIExvYWQgQmFsYW5jZXIuIFVzZXMgYW4gUzMgYnVja2V0XG4gICAqIHdpdGggYXNzb2NpYXRlZCBzdG9yYWdlIGNvc3RzLiBFbmFibGluZyBBY2Nlc3MgTG9nZ2luZyBpcyBhIGJlc3QgcHJhY3RpY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgbG9nQWxiQWNjZXNzTG9ncz86IGJvb2xlYW4sXG4gIC8qKlxuICAgKiBPcHRpb25hbCBwcm9wZXJ0aWVzIHRvIGN1c3RvbWl6ZSB0aGUgYnVja2V0IHVzZWQgdG8gc3RvcmUgdGhlIEFMQiBBY2Nlc3NcbiAgICogTG9ncy4gU3VwcGx5aW5nIHRoaXMgYW5kIHNldHRpbmcgbG9nQWNjZXNzTG9ncyB0byBmYWxzZSBpcyBhbiBlcnJvci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBhbGJMb2dnaW5nQnVja2V0UHJvcHM/OiBzMy5CdWNrZXRQcm9wcyxcbiAgLyoqXG4gICAqIFdoZXRoZXIgdGhlIGNvbnN0cnVjdCBpcyBkZXBsb3lpbmcgYSBwcml2YXRlIG9yIHB1YmxpYyBBUEkuIFRoaXMgaGFzIGltcGxpY2F0aW9ucyBmb3IgdGhlIFZQQyBhbmQgQUxCLlxuICAgKi9cbiAgcmVhZG9ubHkgcHVibGljQXBpOiBib29sZWFuO1xufVxuXG5leHBvcnQgY2xhc3MgQWxiVG9MYW1iZGEgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgbG9hZEJhbGFuY2VyOiBlbGIuQXBwbGljYXRpb25Mb2FkQmFsYW5jZXI7XG4gIHB1YmxpYyByZWFkb25seSB2cGM6IGVjMi5JVnBjO1xuICBwdWJsaWMgcmVhZG9ubHkgbGFtYmRhRnVuY3Rpb246IGxhbWJkYS5GdW5jdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IGxpc3RlbmVyOiBlbGIuQXBwbGljYXRpb25MaXN0ZW5lcjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQWxiVG9MYW1iZGFQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgZGVmYXVsdHMuQ2hlY2tQcm9wcyhwcm9wcyk7XG4gICAgZGVmYXVsdHMuQ2hlY2tBbGJQcm9wcyhwcm9wcyk7XG5cbiAgICAvLyBPYnRhaW4gVlBDIGZvciBjb25zdHJ1Y3QgKGV4aXN0aW5nIG9yIGNyZWF0ZWQpXG4gICAgdGhpcy52cGMgPSBkZWZhdWx0cy5idWlsZFZwYyhzY29wZSwge1xuICAgICAgZXhpc3RpbmdWcGM6IHByb3BzLmV4aXN0aW5nVnBjLFxuICAgICAgZGVmYXVsdFZwY1Byb3BzOiBwcm9wcy5wdWJsaWNBcGkgPyBkZWZhdWx0cy5EZWZhdWx0UHVibGljUHJpdmF0ZVZwY1Byb3BzKCkgOiBkZWZhdWx0cy5EZWZhdWx0SXNvbGF0ZWRWcGNQcm9wcygpLFxuICAgICAgdXNlclZwY1Byb3BzOiBwcm9wcy52cGNQcm9wcyxcbiAgICAgIGNvbnN0cnVjdFZwY1Byb3BzOiBwcm9wcy5wdWJsaWNBcGkgPyB7fSA6IHsgZW5hYmxlRG5zSG9zdG5hbWVzOiB0cnVlLCBlbmFibGVEbnNTdXBwb3J0OiB0cnVlIH1cbiAgICB9KTtcblxuICAgIHRoaXMubG9hZEJhbGFuY2VyID0gZGVmYXVsdHMuT2J0YWluQWxiKFxuICAgICAgdGhpcyxcbiAgICAgIGlkLFxuICAgICAgdGhpcy52cGMsXG4gICAgICBwcm9wcy5wdWJsaWNBcGksXG4gICAgICBwcm9wcy5leGlzdGluZ0xvYWRCYWxhbmNlck9iaixcbiAgICAgIHByb3BzLmxvYWRCYWxhbmNlclByb3BzLFxuICAgICAgcHJvcHMubG9nQWxiQWNjZXNzTG9ncyxcbiAgICAgIHByb3BzLmFsYkxvZ2dpbmdCdWNrZXRQcm9wc1xuICAgICk7XG5cbiAgICAvLyBPYnRhaW4gTGFtYmRhIGZ1bmN0aW9uIGZvciBjb25zdHJ1Y3QgKGV4aXN0aW5nIG9yIGNyZWF0ZWQpXG4gICAgdGhpcy5sYW1iZGFGdW5jdGlvbiA9IGRlZmF1bHRzLmJ1aWxkTGFtYmRhRnVuY3Rpb24odGhpcywge1xuICAgICAgZXhpc3RpbmdMYW1iZGFPYmo6IHByb3BzLmV4aXN0aW5nTGFtYmRhT2JqLFxuICAgICAgbGFtYmRhRnVuY3Rpb25Qcm9wczogcHJvcHMubGFtYmRhRnVuY3Rpb25Qcm9wcyxcbiAgICAgIHZwYzogdGhpcy52cGMsXG4gICAgfSk7XG5cbiAgICBsZXQgbmV3TGlzdGVuZXI6IGJvb2xlYW47XG4gICAgaWYgKHRoaXMubG9hZEJhbGFuY2VyLmxpc3RlbmVycy5sZW5ndGggPT09IDApIHtcbiAgICAgIG5ld0xpc3RlbmVyID0gdHJ1ZTtcbiAgICB9IGVsc2Uge1xuICAgICAgbmV3TGlzdGVuZXIgPSBmYWxzZTtcbiAgICB9XG5cbiAgICAvLyBJZiB0aGVyZSdzIG5vIGxpc3RlbmVyLCB0aGVuIHdlIGFkZCBvbmUgaGVyZVxuICAgIGlmIChuZXdMaXN0ZW5lcikge1xuICAgICAgdGhpcy5saXN0ZW5lciA9IGRlZmF1bHRzLkFkZExpc3RlbmVyKFxuICAgICAgICB0aGlzLFxuICAgICAgICBpZCxcbiAgICAgICAgdGhpcy5sb2FkQmFsYW5jZXIsXG4gICAgICAgIHByb3BzLmxpc3RlbmVyUHJvcHNcbiAgICAgICk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMubGlzdGVuZXIgPSBHZXRBY3RpdmVMaXN0ZW5lcih0aGlzLmxvYWRCYWxhbmNlci5saXN0ZW5lcnMpO1xuICAgIH1cblxuICAgIGNvbnN0IG5ld1RhcmdldEdyb3VwID0gZGVmYXVsdHMuQWRkTGFtYmRhVGFyZ2V0KFxuICAgICAgdGhpcyxcbiAgICAgIGB0ZyR7dGhpcy5sb2FkQmFsYW5jZXIubGlzdGVuZXJzLmxlbmd0aCArIDF9YCxcbiAgICAgIHRoaXMubGlzdGVuZXIsXG4gICAgICB0aGlzLmxhbWJkYUZ1bmN0aW9uLFxuICAgICAgcHJvcHMucnVsZVByb3BzLFxuICAgICAgcHJvcHMudGFyZ2V0UHJvcHMpO1xuXG4gICAgLy8gdGhpcy5saXN0ZW5lciBuZWVkcyB0byBiZSBzZXQgb24gdGhlIGNvbnN0cnVjdC5cbiAgICAvLyBjb3VsZCBiZSBhYm92ZTogZWxzZSB7IGRlZmF1bHRzLkdldEFjdGl2ZUxpc3RlbmVyIH1cbiAgICAvLyBkbyB3ZSB0aGVuIG1vdmUgdGhhdCBmdW5jaW9uYWxpdHkgYmFjayBpbnRvIHRoZSBjb25zdHJ1Y3QgKG5vdCB0aGUgZnVuY3Rpb24pLiBJZiBzbyBkb1xuICAgIC8vIHdlIGxlYXZlIGl0IGluIEFkZE5ld1RhcmdldCBvciBqdXN0IGRvIGl0IGhlcmUgYW5kIHBhc3MgdGhlIGxpc3RlbmVyP1xuICAgIGlmIChuZXdMaXN0ZW5lciAmJiB0aGlzLmxpc3RlbmVyKSB7XG4gICAgICBjb25zdCBsZXZlbE9uZUxpc3RlbmVyID0gdGhpcy5saXN0ZW5lci5ub2RlLmRlZmF1bHRDaGlsZCBhcyBDZm5MaXN0ZW5lcjtcbiAgICAgIGNvbnN0IGNmblRhcmdldEdyb3VwID0gbmV3VGFyZ2V0R3JvdXAubm9kZS5kZWZhdWx0Q2hpbGQgYXMgQ2ZuVGFyZ2V0R3JvdXA7XG4gICAgICBsZXZlbE9uZUxpc3RlbmVyLmFkZERlcGVuZGVuY3koY2ZuVGFyZ2V0R3JvdXApO1xuICAgIH1cblxuICB9XG59XG4iXX0=