# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class SharedAccessConfigCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_type': 'SharedAccessType',
        'users': 'list[str]',
        'organizations': 'list[str]',
        'creator': 'Creator'
    }

    attribute_map = {
        'access_type': 'accessType',
        'users': 'users',
        'organizations': 'organizations',
        'creator': 'creator'
    }

    def __init__(self, access_type=None, users=None, organizations=None, creator=None, _configuration=None):  # noqa: E501
        """SharedAccessConfigCreateRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._access_type = None
        self._users = None
        self._organizations = None
        self._creator = None
        self.discriminator = None

        self.access_type = access_type
        if users is not None:
            self.users = users
        if organizations is not None:
            self.organizations = organizations
        if creator is not None:
            self.creator = creator

    @property
    def access_type(self):
        """Gets the access_type of this SharedAccessConfigCreateRequest.  # noqa: E501


        :return: The access_type of this SharedAccessConfigCreateRequest.  # noqa: E501
        :rtype: SharedAccessType
        """
        return self._access_type

    @access_type.setter
    def access_type(self, access_type):
        """Sets the access_type of this SharedAccessConfigCreateRequest.


        :param access_type: The access_type of this SharedAccessConfigCreateRequest.  # noqa: E501
        :type: SharedAccessType
        """
        if self._configuration.client_side_validation and access_type is None:
            raise ValueError("Invalid value for `access_type`, must not be `None`")  # noqa: E501

        self._access_type = access_type

    @property
    def users(self):
        """Gets the users of this SharedAccessConfigCreateRequest.  # noqa: E501

        List of users with access to the dataset.  # noqa: E501

        :return: The users of this SharedAccessConfigCreateRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._users

    @users.setter
    def users(self, users):
        """Sets the users of this SharedAccessConfigCreateRequest.

        List of users with access to the dataset.  # noqa: E501

        :param users: The users of this SharedAccessConfigCreateRequest.  # noqa: E501
        :type: list[str]
        """

        self._users = users

    @property
    def organizations(self):
        """Gets the organizations of this SharedAccessConfigCreateRequest.  # noqa: E501

        List of organizations with access to the dataset.  # noqa: E501

        :return: The organizations of this SharedAccessConfigCreateRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._organizations

    @organizations.setter
    def organizations(self, organizations):
        """Sets the organizations of this SharedAccessConfigCreateRequest.

        List of organizations with access to the dataset.  # noqa: E501

        :param organizations: The organizations of this SharedAccessConfigCreateRequest.  # noqa: E501
        :type: list[str]
        """

        self._organizations = organizations

    @property
    def creator(self):
        """Gets the creator of this SharedAccessConfigCreateRequest.  # noqa: E501


        :return: The creator of this SharedAccessConfigCreateRequest.  # noqa: E501
        :rtype: Creator
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this SharedAccessConfigCreateRequest.


        :param creator: The creator of this SharedAccessConfigCreateRequest.  # noqa: E501
        :type: Creator
        """

        self._creator = creator

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SharedAccessConfigCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SharedAccessConfigCreateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SharedAccessConfigCreateRequest):
            return True

        return self.to_dict() != other.to_dict()
