# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, Union, Iterable, Optional
from datetime import datetime
from typing_extensions import Required, Annotated, TypedDict

from .._utils import PropertyInfo

__all__ = ["EventIngestParams", "Event"]


class EventIngestParams(TypedDict, total=False):
    events: Required[Iterable[Event]]

    backfill_id: Optional[str]
    """
    If this ingestion request is part of a backfill, this parameter ties the
    ingested events to the backfill
    """

    debug: bool
    """Flag to enable additional debug information in the endpoint response"""


class Event(TypedDict, total=False):
    event_name: Required[str]
    """A name to meaningfully identify the action or event type."""

    idempotency_key: Required[str]
    """A unique value, generated by the client, that is used to de-duplicate events.

    Exactly one event with a given idempotency key will be ingested, which allows
    for safe request retries.
    """

    properties: Required[Dict[str, object]]
    """A dictionary of custom properties.

    Values in this dictionary must be numeric, boolean, or strings. Nested
    dictionaries are disallowed.
    """

    timestamp: Required[Annotated[Union[str, datetime], PropertyInfo(format="iso8601")]]
    """An ISO 8601 format date with no timezone offset (i.e.

    UTC). This should represent the time that usage was recorded, and is
    particularly important to attribute usage to a given billing period.
    """

    customer_id: Optional[str]
    """The Orb Customer identifier"""

    external_customer_id: Optional[str]
    """
    An alias for the Orb customer, whose mapping is specified when creating the
    customer
    """
