# `mssqlServerVulnerabilityAssessment` Submodule <a name="`mssqlServerVulnerabilityAssessment` Submodule" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### MssqlServerVulnerabilityAssessment <a name="MssqlServerVulnerabilityAssessment" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment"></a>

Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment azurerm_mssql_server_vulnerability_assessment}.

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment(
  scope: Construct,
  id: str,
  connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection] = None,
  count: typing.Union[int, float] = None,
  depends_on: typing.List[ITerraformDependable] = None,
  for_each: ITerraformIterator = None,
  lifecycle: TerraformResourceLifecycle = None,
  provider: TerraformProvider = None,
  provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]] = None,
  server_security_alert_policy_id: str,
  storage_container_path: str,
  id: str = None,
  recurring_scans: MssqlServerVulnerabilityAssessmentRecurringScans = None,
  storage_account_access_key: str = None,
  storage_container_sas_key: str = None,
  timeouts: MssqlServerVulnerabilityAssessmentTimeouts = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.id">id</a></code> | <code>str</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.count">count</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.dependsOn">depends_on</a></code> | <code>typing.List[cdktf.ITerraformDependable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.serverSecurityAlertPolicyId">server_security_alert_policy_id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#server_security_alert_policy_id MssqlServerVulnerabilityAssessment#server_security_alert_policy_id}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.storageContainerPath">storage_container_path</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_container_path MssqlServerVulnerabilityAssessment#storage_container_path}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.id">id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#id MssqlServerVulnerabilityAssessment#id}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans">MssqlServerVulnerabilityAssessmentRecurringScans</a></code> | recurring_scans block. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_account_access_key MssqlServerVulnerabilityAssessment#storage_account_access_key}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_container_sas_key MssqlServerVulnerabilityAssessment#storage_container_sas_key}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts">MssqlServerVulnerabilityAssessmentTimeouts</a></code> | timeouts block. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.id"></a>

- *Type:* str

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.connection"></a>

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.count"></a>

- *Type:* typing.Union[int, float]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.dependsOn"></a>

- *Type:* typing.List[cdktf.ITerraformDependable]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.forEach"></a>

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.lifecycle"></a>

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.provider"></a>

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.provisioners"></a>

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `server_security_alert_policy_id`<sup>Required</sup> <a name="server_security_alert_policy_id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.serverSecurityAlertPolicyId"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#server_security_alert_policy_id MssqlServerVulnerabilityAssessment#server_security_alert_policy_id}.

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.storageContainerPath"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_container_path MssqlServerVulnerabilityAssessment#storage_container_path}.

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.id"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#id MssqlServerVulnerabilityAssessment#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `recurring_scans`<sup>Optional</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.recurringScans"></a>

- *Type:* <a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans">MssqlServerVulnerabilityAssessmentRecurringScans</a>

recurring_scans block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#recurring_scans MssqlServerVulnerabilityAssessment#recurring_scans}

---

##### `storage_account_access_key`<sup>Optional</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.storageAccountAccessKey"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_account_access_key MssqlServerVulnerabilityAssessment#storage_account_access_key}.

---

##### `storage_container_sas_key`<sup>Optional</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.storageContainerSasKey"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_container_sas_key MssqlServerVulnerabilityAssessment#storage_container_sas_key}.

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.Initializer.parameter.timeouts"></a>

- *Type:* <a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts">MssqlServerVulnerabilityAssessmentTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#timeouts MssqlServerVulnerabilityAssessment#timeouts}

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.addOverride">add_override</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.overrideLogicalId">override_logical_id</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetOverrideLogicalId">reset_override_logical_id</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.toMetadata">to_metadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.toTerraform">to_terraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putRecurringScans">put_recurring_scans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putTimeouts">put_timeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetId">reset_id</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetRecurringScans">reset_recurring_scans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetStorageAccountAccessKey">reset_storage_account_access_key</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetStorageContainerSasKey">reset_storage_container_sas_key</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetTimeouts">reset_timeouts</a></code> | *No description.* |

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_override` <a name="add_override" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.addOverride"></a>

```python
def add_override(
  path: str,
  value: typing.Any
) -> None
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.addOverride.parameter.path"></a>

- *Type:* str

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.addOverride.parameter.value"></a>

- *Type:* typing.Any

---

##### `override_logical_id` <a name="override_logical_id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.overrideLogicalId"></a>

```python
def override_logical_id(
  new_logical_id: str
) -> None
```

Overrides the auto-generated logical ID with a specific ID.

###### `new_logical_id`<sup>Required</sup> <a name="new_logical_id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* str

The new logical ID to use for this stack element.

---

##### `reset_override_logical_id` <a name="reset_override_logical_id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetOverrideLogicalId"></a>

```python
def reset_override_logical_id() -> None
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `to_metadata` <a name="to_metadata" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.toMetadata"></a>

```python
def to_metadata() -> typing.Any
```

##### `to_terraform` <a name="to_terraform" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.toTerraform"></a>

```python
def to_terraform() -> typing.Any
```

Adds this resource to the terraform JSON output.

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `put_recurring_scans` <a name="put_recurring_scans" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putRecurringScans"></a>

```python
def put_recurring_scans(
  emails: typing.List[str] = None,
  email_subscription_admins: typing.Union[bool, IResolvable] = None,
  enabled: typing.Union[bool, IResolvable] = None
) -> None
```

###### `emails`<sup>Optional</sup> <a name="emails" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putRecurringScans.parameter.emails"></a>

- *Type:* typing.List[str]

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#emails MssqlServerVulnerabilityAssessment#emails}.

---

###### `email_subscription_admins`<sup>Optional</sup> <a name="email_subscription_admins" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putRecurringScans.parameter.emailSubscriptionAdmins"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#email_subscription_admins MssqlServerVulnerabilityAssessment#email_subscription_admins}.

---

###### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putRecurringScans.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#enabled MssqlServerVulnerabilityAssessment#enabled}.

---

##### `put_timeouts` <a name="put_timeouts" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putTimeouts"></a>

```python
def put_timeouts(
  create: str = None,
  delete: str = None,
  read: str = None,
  update: str = None
) -> None
```

###### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putTimeouts.parameter.create"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#create MssqlServerVulnerabilityAssessment#create}.

---

###### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putTimeouts.parameter.delete"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#delete MssqlServerVulnerabilityAssessment#delete}.

---

###### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putTimeouts.parameter.read"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#read MssqlServerVulnerabilityAssessment#read}.

---

###### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.putTimeouts.parameter.update"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#update MssqlServerVulnerabilityAssessment#update}.

---

##### `reset_id` <a name="reset_id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetId"></a>

```python
def reset_id() -> None
```

##### `reset_recurring_scans` <a name="reset_recurring_scans" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetRecurringScans"></a>

```python
def reset_recurring_scans() -> None
```

##### `reset_storage_account_access_key` <a name="reset_storage_account_access_key" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetStorageAccountAccessKey"></a>

```python
def reset_storage_account_access_key() -> None
```

##### `reset_storage_container_sas_key` <a name="reset_storage_container_sas_key" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetStorageContainerSasKey"></a>

```python
def reset_storage_container_sas_key() -> None
```

##### `reset_timeouts` <a name="reset_timeouts" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.resetTimeouts"></a>

```python
def reset_timeouts() -> None
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isTerraformElement">is_terraform_element</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isTerraformResource">is_terraform_resource</a></code> | *No description.* |

---

##### `is_construct` <a name="is_construct" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isConstruct"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

##### `is_terraform_element` <a name="is_terraform_element" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isTerraformElement"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.is_terraform_element(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isTerraformElement.parameter.x"></a>

- *Type:* typing.Any

---

##### `is_terraform_resource` <a name="is_terraform_resource" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isTerraformResource"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.is_terraform_resource(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.isTerraformResource.parameter.x"></a>

- *Type:* typing.Any

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.cdktfStack">cdktf_stack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.friendlyUniqueId">friendly_unique_id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.terraformMetaArguments">terraform_meta_arguments</a></code> | <code>typing.Mapping[typing.Any]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.terraformResourceType">terraform_resource_type</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.terraformGeneratorMetadata">terraform_generator_metadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.count">count</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.dependsOn">depends_on</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference">MssqlServerVulnerabilityAssessmentRecurringScansOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference">MssqlServerVulnerabilityAssessmentTimeoutsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.idInput">id_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.recurringScansInput">recurring_scans_input</a></code> | <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans">MssqlServerVulnerabilityAssessmentRecurringScans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.serverSecurityAlertPolicyIdInput">server_security_alert_policy_id_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageAccountAccessKeyInput">storage_account_access_key_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageContainerPathInput">storage_container_path_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageContainerSasKeyInput">storage_container_sas_key_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.timeoutsInput">timeouts_input</a></code> | <code>typing.Union[<a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts">MssqlServerVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.serverSecurityAlertPolicyId">server_security_alert_policy_id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageContainerPath">storage_container_path</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktf_stack`<sup>Required</sup> <a name="cdktf_stack" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.cdktfStack"></a>

```python
cdktf_stack: TerraformStack
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `friendly_unique_id`<sup>Required</sup> <a name="friendly_unique_id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.friendlyUniqueId"></a>

```python
friendly_unique_id: str
```

- *Type:* str

---

##### `terraform_meta_arguments`<sup>Required</sup> <a name="terraform_meta_arguments" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.terraformMetaArguments"></a>

```python
terraform_meta_arguments: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]

---

##### `terraform_resource_type`<sup>Required</sup> <a name="terraform_resource_type" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.terraformResourceType"></a>

```python
terraform_resource_type: str
```

- *Type:* str

---

##### `terraform_generator_metadata`<sup>Optional</sup> <a name="terraform_generator_metadata" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.terraformGeneratorMetadata"></a>

```python
terraform_generator_metadata: TerraformProviderGeneratorMetadata
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.connection"></a>

```python
connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection]
```

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.count"></a>

```python
count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.dependsOn"></a>

```python
depends_on: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.forEach"></a>

```python
for_each: ITerraformIterator
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.lifecycle"></a>

```python
lifecycle: TerraformResourceLifecycle
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.provider"></a>

```python
provider: TerraformProvider
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.provisioners"></a>

```python
provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]
```

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `recurring_scans`<sup>Required</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.recurringScans"></a>

```python
recurring_scans: MssqlServerVulnerabilityAssessmentRecurringScansOutputReference
```

- *Type:* <a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference">MssqlServerVulnerabilityAssessmentRecurringScansOutputReference</a>

---

##### `timeouts`<sup>Required</sup> <a name="timeouts" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.timeouts"></a>

```python
timeouts: MssqlServerVulnerabilityAssessmentTimeoutsOutputReference
```

- *Type:* <a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference">MssqlServerVulnerabilityAssessmentTimeoutsOutputReference</a>

---

##### `id_input`<sup>Optional</sup> <a name="id_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.idInput"></a>

```python
id_input: str
```

- *Type:* str

---

##### `recurring_scans_input`<sup>Optional</sup> <a name="recurring_scans_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.recurringScansInput"></a>

```python
recurring_scans_input: MssqlServerVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans">MssqlServerVulnerabilityAssessmentRecurringScans</a>

---

##### `server_security_alert_policy_id_input`<sup>Optional</sup> <a name="server_security_alert_policy_id_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.serverSecurityAlertPolicyIdInput"></a>

```python
server_security_alert_policy_id_input: str
```

- *Type:* str

---

##### `storage_account_access_key_input`<sup>Optional</sup> <a name="storage_account_access_key_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageAccountAccessKeyInput"></a>

```python
storage_account_access_key_input: str
```

- *Type:* str

---

##### `storage_container_path_input`<sup>Optional</sup> <a name="storage_container_path_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageContainerPathInput"></a>

```python
storage_container_path_input: str
```

- *Type:* str

---

##### `storage_container_sas_key_input`<sup>Optional</sup> <a name="storage_container_sas_key_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageContainerSasKeyInput"></a>

```python
storage_container_sas_key_input: str
```

- *Type:* str

---

##### `timeouts_input`<sup>Optional</sup> <a name="timeouts_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.timeoutsInput"></a>

```python
timeouts_input: typing.Union[MssqlServerVulnerabilityAssessmentTimeouts, IResolvable]
```

- *Type:* typing.Union[<a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts">MssqlServerVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.id"></a>

```python
id: str
```

- *Type:* str

---

##### `server_security_alert_policy_id`<sup>Required</sup> <a name="server_security_alert_policy_id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.serverSecurityAlertPolicyId"></a>

```python
server_security_alert_policy_id: str
```

- *Type:* str

---

##### `storage_account_access_key`<sup>Required</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageAccountAccessKey"></a>

```python
storage_account_access_key: str
```

- *Type:* str

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageContainerPath"></a>

```python
storage_container_path: str
```

- *Type:* str

---

##### `storage_container_sas_key`<sup>Required</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.storageContainerSasKey"></a>

```python
storage_container_sas_key: str
```

- *Type:* str

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.tfResourceType">tfResourceType</a></code> | <code>str</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessment.property.tfResourceType"></a>

```python
tfResourceType: str
```

- *Type:* str

---

## Structs <a name="Structs" id="Structs"></a>

### MssqlServerVulnerabilityAssessmentConfig <a name="MssqlServerVulnerabilityAssessmentConfig" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig(
  connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection] = None,
  count: typing.Union[int, float] = None,
  depends_on: typing.List[ITerraformDependable] = None,
  for_each: ITerraformIterator = None,
  lifecycle: TerraformResourceLifecycle = None,
  provider: TerraformProvider = None,
  provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]] = None,
  server_security_alert_policy_id: str,
  storage_container_path: str,
  id: str = None,
  recurring_scans: MssqlServerVulnerabilityAssessmentRecurringScans = None,
  storage_account_access_key: str = None,
  storage_container_sas_key: str = None,
  timeouts: MssqlServerVulnerabilityAssessmentTimeouts = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.count">count</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.dependsOn">depends_on</a></code> | <code>typing.List[cdktf.ITerraformDependable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.serverSecurityAlertPolicyId">server_security_alert_policy_id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#server_security_alert_policy_id MssqlServerVulnerabilityAssessment#server_security_alert_policy_id}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.storageContainerPath">storage_container_path</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_container_path MssqlServerVulnerabilityAssessment#storage_container_path}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.id">id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#id MssqlServerVulnerabilityAssessment#id}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans">MssqlServerVulnerabilityAssessmentRecurringScans</a></code> | recurring_scans block. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_account_access_key MssqlServerVulnerabilityAssessment#storage_account_access_key}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_container_sas_key MssqlServerVulnerabilityAssessment#storage_container_sas_key}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts">MssqlServerVulnerabilityAssessmentTimeouts</a></code> | timeouts block. |

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.connection"></a>

```python
connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection]
```

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.count"></a>

```python
count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.dependsOn"></a>

```python
depends_on: typing.List[ITerraformDependable]
```

- *Type:* typing.List[cdktf.ITerraformDependable]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.forEach"></a>

```python
for_each: ITerraformIterator
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.lifecycle"></a>

```python
lifecycle: TerraformResourceLifecycle
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.provider"></a>

```python
provider: TerraformProvider
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.provisioners"></a>

```python
provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]
```

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `server_security_alert_policy_id`<sup>Required</sup> <a name="server_security_alert_policy_id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.serverSecurityAlertPolicyId"></a>

```python
server_security_alert_policy_id: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#server_security_alert_policy_id MssqlServerVulnerabilityAssessment#server_security_alert_policy_id}.

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.storageContainerPath"></a>

```python
storage_container_path: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_container_path MssqlServerVulnerabilityAssessment#storage_container_path}.

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#id MssqlServerVulnerabilityAssessment#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `recurring_scans`<sup>Optional</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.recurringScans"></a>

```python
recurring_scans: MssqlServerVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans">MssqlServerVulnerabilityAssessmentRecurringScans</a>

recurring_scans block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#recurring_scans MssqlServerVulnerabilityAssessment#recurring_scans}

---

##### `storage_account_access_key`<sup>Optional</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.storageAccountAccessKey"></a>

```python
storage_account_access_key: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_account_access_key MssqlServerVulnerabilityAssessment#storage_account_access_key}.

---

##### `storage_container_sas_key`<sup>Optional</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.storageContainerSasKey"></a>

```python
storage_container_sas_key: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#storage_container_sas_key MssqlServerVulnerabilityAssessment#storage_container_sas_key}.

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentConfig.property.timeouts"></a>

```python
timeouts: MssqlServerVulnerabilityAssessmentTimeouts
```

- *Type:* <a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts">MssqlServerVulnerabilityAssessmentTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#timeouts MssqlServerVulnerabilityAssessment#timeouts}

---

### MssqlServerVulnerabilityAssessmentRecurringScans <a name="MssqlServerVulnerabilityAssessmentRecurringScans" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans(
  emails: typing.List[str] = None,
  email_subscription_admins: typing.Union[bool, IResolvable] = None,
  enabled: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans.property.emails">emails</a></code> | <code>typing.List[str]</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#emails MssqlServerVulnerabilityAssessment#emails}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans.property.emailSubscriptionAdmins">email_subscription_admins</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#email_subscription_admins MssqlServerVulnerabilityAssessment#email_subscription_admins}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#enabled MssqlServerVulnerabilityAssessment#enabled}. |

---

##### `emails`<sup>Optional</sup> <a name="emails" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans.property.emails"></a>

```python
emails: typing.List[str]
```

- *Type:* typing.List[str]

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#emails MssqlServerVulnerabilityAssessment#emails}.

---

##### `email_subscription_admins`<sup>Optional</sup> <a name="email_subscription_admins" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans.property.emailSubscriptionAdmins"></a>

```python
email_subscription_admins: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#email_subscription_admins MssqlServerVulnerabilityAssessment#email_subscription_admins}.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#enabled MssqlServerVulnerabilityAssessment#enabled}.

---

### MssqlServerVulnerabilityAssessmentTimeouts <a name="MssqlServerVulnerabilityAssessmentTimeouts" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts(
  create: str = None,
  delete: str = None,
  read: str = None,
  update: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.property.create">create</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#create MssqlServerVulnerabilityAssessment#create}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.property.delete">delete</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#delete MssqlServerVulnerabilityAssessment#delete}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.property.read">read</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#read MssqlServerVulnerabilityAssessment#read}. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.property.update">update</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#update MssqlServerVulnerabilityAssessment#update}. |

---

##### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.property.create"></a>

```python
create: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#create MssqlServerVulnerabilityAssessment#create}.

---

##### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.property.delete"></a>

```python
delete: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#delete MssqlServerVulnerabilityAssessment#delete}.

---

##### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.property.read"></a>

```python
read: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#read MssqlServerVulnerabilityAssessment#read}.

---

##### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts.property.update"></a>

```python
update: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_vulnerability_assessment#update MssqlServerVulnerabilityAssessment#update}.

---

## Classes <a name="Classes" id="Classes"></a>

### MssqlServerVulnerabilityAssessmentRecurringScansOutputReference <a name="MssqlServerVulnerabilityAssessmentRecurringScansOutputReference" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resetEmails">reset_emails</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resetEmailSubscriptionAdmins">reset_email_subscription_admins</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resetEnabled">reset_enabled</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_emails` <a name="reset_emails" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resetEmails"></a>

```python
def reset_emails() -> None
```

##### `reset_email_subscription_admins` <a name="reset_email_subscription_admins" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resetEmailSubscriptionAdmins"></a>

```python
def reset_email_subscription_admins() -> None
```

##### `reset_enabled` <a name="reset_enabled" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.resetEnabled"></a>

```python
def reset_enabled() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.emailsInput">emails_input</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsInput">email_subscription_admins_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.emails">emails</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdmins">email_subscription_admins</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans">MssqlServerVulnerabilityAssessmentRecurringScans</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `emails_input`<sup>Optional</sup> <a name="emails_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.emailsInput"></a>

```python
emails_input: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `email_subscription_admins_input`<sup>Optional</sup> <a name="email_subscription_admins_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsInput"></a>

```python
email_subscription_admins_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `emails`<sup>Required</sup> <a name="emails" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.emails"></a>

```python
emails: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `email_subscription_admins`<sup>Required</sup> <a name="email_subscription_admins" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdmins"></a>

```python
email_subscription_admins: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScansOutputReference.property.internalValue"></a>

```python
internal_value: MssqlServerVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentRecurringScans">MssqlServerVulnerabilityAssessmentRecurringScans</a>

---


### MssqlServerVulnerabilityAssessmentTimeoutsOutputReference <a name="MssqlServerVulnerabilityAssessmentTimeoutsOutputReference" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import mssql_server_vulnerability_assessment

mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resetCreate">reset_create</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resetDelete">reset_delete</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resetRead">reset_read</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resetUpdate">reset_update</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_create` <a name="reset_create" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resetCreate"></a>

```python
def reset_create() -> None
```

##### `reset_delete` <a name="reset_delete" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resetDelete"></a>

```python
def reset_delete() -> None
```

##### `reset_read` <a name="reset_read" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resetRead"></a>

```python
def reset_read() -> None
```

##### `reset_update` <a name="reset_update" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.resetUpdate"></a>

```python
def reset_update() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.createInput">create_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.deleteInput">delete_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.readInput">read_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.updateInput">update_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.create">create</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.delete">delete</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.read">read</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.update">update</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.internalValue">internal_value</a></code> | <code>typing.Union[<a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts">MssqlServerVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]</code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `create_input`<sup>Optional</sup> <a name="create_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.createInput"></a>

```python
create_input: str
```

- *Type:* str

---

##### `delete_input`<sup>Optional</sup> <a name="delete_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.deleteInput"></a>

```python
delete_input: str
```

- *Type:* str

---

##### `read_input`<sup>Optional</sup> <a name="read_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.readInput"></a>

```python
read_input: str
```

- *Type:* str

---

##### `update_input`<sup>Optional</sup> <a name="update_input" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.updateInput"></a>

```python
update_input: str
```

- *Type:* str

---

##### `create`<sup>Required</sup> <a name="create" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.create"></a>

```python
create: str
```

- *Type:* str

---

##### `delete`<sup>Required</sup> <a name="delete" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.delete"></a>

```python
delete: str
```

- *Type:* str

---

##### `read`<sup>Required</sup> <a name="read" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.read"></a>

```python
read: str
```

- *Type:* str

---

##### `update`<sup>Required</sup> <a name="update" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.update"></a>

```python
update: str
```

- *Type:* str

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeoutsOutputReference.property.internalValue"></a>

```python
internal_value: typing.Union[MssqlServerVulnerabilityAssessmentTimeouts, IResolvable]
```

- *Type:* typing.Union[<a href="#@cdktf/provider-azurerm.mssqlServerVulnerabilityAssessment.MssqlServerVulnerabilityAssessmentTimeouts">MssqlServerVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]

---



