import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CostAnomalyAlertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#display_name CostAnomalyAlert#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#email_addresses CostAnomalyAlert#email_addresses}
    */
    readonly emailAddresses: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#email_subject CostAnomalyAlert#email_subject}
    */
    readonly emailSubject: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#id CostAnomalyAlert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#message CostAnomalyAlert#message}
    */
    readonly message?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#name CostAnomalyAlert#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#timeouts CostAnomalyAlert#timeouts}
    */
    readonly timeouts?: CostAnomalyAlertTimeouts;
}
export interface CostAnomalyAlertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#create CostAnomalyAlert#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#delete CostAnomalyAlert#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#read CostAnomalyAlert#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert#update CostAnomalyAlert#update}
    */
    readonly update?: string;
}
export declare function costAnomalyAlertTimeoutsToTerraform(struct?: CostAnomalyAlertTimeoutsOutputReference | CostAnomalyAlertTimeouts | cdktf.IResolvable): any;
export declare class CostAnomalyAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CostAnomalyAlertTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CostAnomalyAlertTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert azurerm_cost_anomaly_alert}
*/
export declare class CostAnomalyAlert extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cost_anomaly_alert";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cost_anomaly_alert azurerm_cost_anomaly_alert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CostAnomalyAlertConfig
    */
    constructor(scope: Construct, id: string, config: CostAnomalyAlertConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    get emailAddressesInput(): string[] | undefined;
    private _emailSubject?;
    get emailSubject(): string;
    set emailSubject(value: string);
    get emailSubjectInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    resetMessage(): void;
    get messageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): CostAnomalyAlertTimeoutsOutputReference;
    putTimeouts(value: CostAnomalyAlertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CostAnomalyAlertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
