import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerAppEnvironmentCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Container App Managed Environment ID to configure this Certificate on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_app_environment_certificate#container_app_environment_id DataAzurermContainerAppEnvironmentCertificate#container_app_environment_id}
    */
    readonly containerAppEnvironmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_app_environment_certificate#id DataAzurermContainerAppEnvironmentCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Container Apps Certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_app_environment_certificate#name DataAzurermContainerAppEnvironmentCertificate#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_app_environment_certificate#timeouts DataAzurermContainerAppEnvironmentCertificate#timeouts}
    */
    readonly timeouts?: DataAzurermContainerAppEnvironmentCertificateTimeouts;
}
export interface DataAzurermContainerAppEnvironmentCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_app_environment_certificate#read DataAzurermContainerAppEnvironmentCertificate#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerAppEnvironmentCertificateTimeoutsToTerraform(struct?: DataAzurermContainerAppEnvironmentCertificateTimeoutsOutputReference | DataAzurermContainerAppEnvironmentCertificateTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerAppEnvironmentCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermContainerAppEnvironmentCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermContainerAppEnvironmentCertificateTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/container_app_environment_certificate azurerm_container_app_environment_certificate}
*/
export declare class DataAzurermContainerAppEnvironmentCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_container_app_environment_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/container_app_environment_certificate azurerm_container_app_environment_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerAppEnvironmentCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerAppEnvironmentCertificateConfig);
    private _containerAppEnvironmentId?;
    get containerAppEnvironmentId(): string;
    set containerAppEnvironmentId(value: string);
    get containerAppEnvironmentIdInput(): string | undefined;
    get expirationDate(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issueDate(): string;
    get issuer(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get subjectName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get thumbprint(): string;
    private _timeouts;
    get timeouts(): DataAzurermContainerAppEnvironmentCertificateTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerAppEnvironmentCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermContainerAppEnvironmentCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
