import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#id DataAzurermKeyVaultSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#key_vault_id DataAzurermKeyVaultSecret#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#name DataAzurermKeyVaultSecret#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#timeouts DataAzurermKeyVaultSecret#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultSecretTimeouts;
}
export interface DataAzurermKeyVaultSecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#read DataAzurermKeyVaultSecret#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultSecretTimeoutsToTerraform(struct?: DataAzurermKeyVaultSecretTimeoutsOutputReference | DataAzurermKeyVaultSecretTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultSecretTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKeyVaultSecretTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret azurerm_key_vault_secret}
*/
export declare class DataAzurermKeyVaultSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret azurerm_key_vault_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultSecretConfig);
    get contentType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get resourceId(): string;
    get resourceVersionlessId(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get value(): string;
    get version(): string;
    get versionlessId(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultSecretTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultSecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKeyVaultSecretTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
