import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_service#id DataAzurermMobileNetworkService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_service#mobile_network_id DataAzurermMobileNetworkService#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_service#name DataAzurermMobileNetworkService#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_service#timeouts DataAzurermMobileNetworkService#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkServiceTimeouts;
}
export interface DataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRate {
}
export declare function dataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRateToTerraform(struct?: DataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRate): any;
export declare class DataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRate | undefined;
    set internalValue(value: DataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRate | undefined);
    get downlink(): string;
    get uplink(): string;
}
export declare class DataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRateOutputReference;
}
export interface DataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRate {
}
export declare function dataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRateToTerraform(struct?: DataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRate): any;
export declare class DataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRate | undefined;
    set internalValue(value: DataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRate | undefined);
    get downlink(): string;
    get uplink(): string;
}
export declare class DataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRateOutputReference;
}
export interface DataAzurermMobileNetworkServicePccRuleQosPolicy {
}
export declare function dataAzurermMobileNetworkServicePccRuleQosPolicyToTerraform(struct?: DataAzurermMobileNetworkServicePccRuleQosPolicy): any;
export declare class DataAzurermMobileNetworkServicePccRuleQosPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkServicePccRuleQosPolicy | undefined;
    set internalValue(value: DataAzurermMobileNetworkServicePccRuleQosPolicy | undefined);
    get allocationAndRetentionPriorityLevel(): number;
    private _guaranteedBitRate;
    get guaranteedBitRate(): DataAzurermMobileNetworkServicePccRuleQosPolicyGuaranteedBitRateList;
    private _maximumBitRate;
    get maximumBitRate(): DataAzurermMobileNetworkServicePccRuleQosPolicyMaximumBitRateList;
    get preemptionCapability(): string;
    get preemptionVulnerability(): string;
    get qosIndicator(): number;
}
export declare class DataAzurermMobileNetworkServicePccRuleQosPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkServicePccRuleQosPolicyOutputReference;
}
export interface DataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplate {
}
export declare function dataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplateToTerraform(struct?: DataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplate): any;
export declare class DataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplate | undefined;
    set internalValue(value: DataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplate | undefined);
    get direction(): string;
    get name(): string;
    get ports(): string[];
    get protocol(): string[];
    get remoteIpList(): string[];
}
export declare class DataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplateOutputReference;
}
export interface DataAzurermMobileNetworkServicePccRule {
}
export declare function dataAzurermMobileNetworkServicePccRuleToTerraform(struct?: DataAzurermMobileNetworkServicePccRule): any;
export declare class DataAzurermMobileNetworkServicePccRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkServicePccRule | undefined;
    set internalValue(value: DataAzurermMobileNetworkServicePccRule | undefined);
    get name(): string;
    get precedence(): number;
    private _qosPolicy;
    get qosPolicy(): DataAzurermMobileNetworkServicePccRuleQosPolicyList;
    private _serviceDataFlowTemplate;
    get serviceDataFlowTemplate(): DataAzurermMobileNetworkServicePccRuleServiceDataFlowTemplateList;
    get trafficControlEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermMobileNetworkServicePccRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkServicePccRuleOutputReference;
}
export interface DataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRate {
}
export declare function dataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRateToTerraform(struct?: DataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRate): any;
export declare class DataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRate | undefined;
    set internalValue(value: DataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRate | undefined);
    get downlink(): string;
    get uplink(): string;
}
export declare class DataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRateOutputReference;
}
export interface DataAzurermMobileNetworkServiceServiceQosPolicy {
}
export declare function dataAzurermMobileNetworkServiceServiceQosPolicyToTerraform(struct?: DataAzurermMobileNetworkServiceServiceQosPolicy): any;
export declare class DataAzurermMobileNetworkServiceServiceQosPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkServiceServiceQosPolicy | undefined;
    set internalValue(value: DataAzurermMobileNetworkServiceServiceQosPolicy | undefined);
    get allocationAndRetentionPriorityLevel(): number;
    private _maximumBitRate;
    get maximumBitRate(): DataAzurermMobileNetworkServiceServiceQosPolicyMaximumBitRateList;
    get preemptionCapability(): string;
    get preemptionVulnerability(): string;
    get qosIndicator(): number;
}
export declare class DataAzurermMobileNetworkServiceServiceQosPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkServiceServiceQosPolicyOutputReference;
}
export interface DataAzurermMobileNetworkServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_service#read DataAzurermMobileNetworkService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkServiceTimeoutsToTerraform(struct?: DataAzurermMobileNetworkServiceTimeoutsOutputReference | DataAzurermMobileNetworkServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_service azurerm_mobile_network_service}
*/
export declare class DataAzurermMobileNetworkService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_service azurerm_mobile_network_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkServiceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pccRule;
    get pccRule(): DataAzurermMobileNetworkServicePccRuleList;
    get servicePrecedence(): number;
    private _serviceQosPolicy;
    get serviceQosPolicy(): DataAzurermMobileNetworkServiceServiceQosPolicyList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
