import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkSiteConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_site#id DataAzurermMobileNetworkSite#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_site#mobile_network_id DataAzurermMobileNetworkSite#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_site#name DataAzurermMobileNetworkSite#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_site#timeouts DataAzurermMobileNetworkSite#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkSiteTimeouts;
}
export interface DataAzurermMobileNetworkSiteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_site#read DataAzurermMobileNetworkSite#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkSiteTimeoutsToTerraform(struct?: DataAzurermMobileNetworkSiteTimeoutsOutputReference | DataAzurermMobileNetworkSiteTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkSiteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkSiteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkSiteTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_site azurerm_mobile_network_site}
*/
export declare class DataAzurermMobileNetworkSite extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_site";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_site azurerm_mobile_network_site} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkSiteConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkSiteConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkFunctionIds(): string[];
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkSiteTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkSiteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkSiteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
