import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkSliceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_slice#id DataAzurermMobileNetworkSlice#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_slice#mobile_network_id DataAzurermMobileNetworkSlice#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_slice#name DataAzurermMobileNetworkSlice#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_slice#timeouts DataAzurermMobileNetworkSlice#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkSliceTimeouts;
}
export interface DataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation {
}
export declare function dataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationToTerraform(struct?: DataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation): any;
export declare class DataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation | undefined;
    set internalValue(value: DataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation | undefined);
    get sliceDifferentiator(): string;
    get sliceServiceType(): number;
}
export declare class DataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationOutputReference;
}
export interface DataAzurermMobileNetworkSliceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_slice#read DataAzurermMobileNetworkSlice#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkSliceTimeoutsToTerraform(struct?: DataAzurermMobileNetworkSliceTimeoutsOutputReference | DataAzurermMobileNetworkSliceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkSliceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkSliceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkSliceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_slice azurerm_mobile_network_slice}
*/
export declare class DataAzurermMobileNetworkSlice extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_slice";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network_slice azurerm_mobile_network_slice} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkSliceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkSliceConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _singleNetworkSliceSelectionAssistanceInformation;
    get singleNetworkSliceSelectionAssistanceInformation(): DataAzurermMobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkSliceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkSliceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkSliceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
