import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExpressRouteConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#authorization_key ExpressRouteConnection#authorization_key}
    */
    readonly authorizationKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#enable_internet_security ExpressRouteConnection#enable_internet_security}
    */
    readonly enableInternetSecurity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#express_route_circuit_peering_id ExpressRouteConnection#express_route_circuit_peering_id}
    */
    readonly expressRouteCircuitPeeringId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#express_route_gateway_bypass_enabled ExpressRouteConnection#express_route_gateway_bypass_enabled}
    */
    readonly expressRouteGatewayBypassEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#express_route_gateway_id ExpressRouteConnection#express_route_gateway_id}
    */
    readonly expressRouteGatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#id ExpressRouteConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#name ExpressRouteConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#routing_weight ExpressRouteConnection#routing_weight}
    */
    readonly routingWeight?: number;
    /**
    * routing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#routing ExpressRouteConnection#routing}
    */
    readonly routing?: ExpressRouteConnectionRouting;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#timeouts ExpressRouteConnection#timeouts}
    */
    readonly timeouts?: ExpressRouteConnectionTimeouts;
}
export interface ExpressRouteConnectionRoutingPropagatedRouteTable {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#labels ExpressRouteConnection#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#route_table_ids ExpressRouteConnection#route_table_ids}
    */
    readonly routeTableIds?: string[];
}
export declare function expressRouteConnectionRoutingPropagatedRouteTableToTerraform(struct?: ExpressRouteConnectionRoutingPropagatedRouteTableOutputReference | ExpressRouteConnectionRoutingPropagatedRouteTable): any;
export declare class ExpressRouteConnectionRoutingPropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteConnectionRoutingPropagatedRouteTable | undefined;
    set internalValue(value: ExpressRouteConnectionRoutingPropagatedRouteTable | undefined);
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _routeTableIds?;
    get routeTableIds(): string[];
    set routeTableIds(value: string[]);
    resetRouteTableIds(): void;
    get routeTableIdsInput(): string[] | undefined;
}
export interface ExpressRouteConnectionRouting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#associated_route_table_id ExpressRouteConnection#associated_route_table_id}
    */
    readonly associatedRouteTableId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#inbound_route_map_id ExpressRouteConnection#inbound_route_map_id}
    */
    readonly inboundRouteMapId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#outbound_route_map_id ExpressRouteConnection#outbound_route_map_id}
    */
    readonly outboundRouteMapId?: string;
    /**
    * propagated_route_table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#propagated_route_table ExpressRouteConnection#propagated_route_table}
    */
    readonly propagatedRouteTable?: ExpressRouteConnectionRoutingPropagatedRouteTable;
}
export declare function expressRouteConnectionRoutingToTerraform(struct?: ExpressRouteConnectionRoutingOutputReference | ExpressRouteConnectionRouting): any;
export declare class ExpressRouteConnectionRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteConnectionRouting | undefined;
    set internalValue(value: ExpressRouteConnectionRouting | undefined);
    private _associatedRouteTableId?;
    get associatedRouteTableId(): string;
    set associatedRouteTableId(value: string);
    resetAssociatedRouteTableId(): void;
    get associatedRouteTableIdInput(): string | undefined;
    private _inboundRouteMapId?;
    get inboundRouteMapId(): string;
    set inboundRouteMapId(value: string);
    resetInboundRouteMapId(): void;
    get inboundRouteMapIdInput(): string | undefined;
    private _outboundRouteMapId?;
    get outboundRouteMapId(): string;
    set outboundRouteMapId(value: string);
    resetOutboundRouteMapId(): void;
    get outboundRouteMapIdInput(): string | undefined;
    private _propagatedRouteTable;
    get propagatedRouteTable(): ExpressRouteConnectionRoutingPropagatedRouteTableOutputReference;
    putPropagatedRouteTable(value: ExpressRouteConnectionRoutingPropagatedRouteTable): void;
    resetPropagatedRouteTable(): void;
    get propagatedRouteTableInput(): ExpressRouteConnectionRoutingPropagatedRouteTable | undefined;
}
export interface ExpressRouteConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#create ExpressRouteConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#delete ExpressRouteConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#read ExpressRouteConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#update ExpressRouteConnection#update}
    */
    readonly update?: string;
}
export declare function expressRouteConnectionTimeoutsToTerraform(struct?: ExpressRouteConnectionTimeoutsOutputReference | ExpressRouteConnectionTimeouts | cdktf.IResolvable): any;
export declare class ExpressRouteConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ExpressRouteConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection azurerm_express_route_connection}
*/
export declare class ExpressRouteConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_express_route_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection azurerm_express_route_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExpressRouteConnectionConfig
    */
    constructor(scope: Construct, id: string, config: ExpressRouteConnectionConfig);
    private _authorizationKey?;
    get authorizationKey(): string;
    set authorizationKey(value: string);
    resetAuthorizationKey(): void;
    get authorizationKeyInput(): string | undefined;
    private _enableInternetSecurity?;
    get enableInternetSecurity(): boolean | cdktf.IResolvable;
    set enableInternetSecurity(value: boolean | cdktf.IResolvable);
    resetEnableInternetSecurity(): void;
    get enableInternetSecurityInput(): boolean | cdktf.IResolvable | undefined;
    private _expressRouteCircuitPeeringId?;
    get expressRouteCircuitPeeringId(): string;
    set expressRouteCircuitPeeringId(value: string);
    get expressRouteCircuitPeeringIdInput(): string | undefined;
    private _expressRouteGatewayBypassEnabled?;
    get expressRouteGatewayBypassEnabled(): boolean | cdktf.IResolvable;
    set expressRouteGatewayBypassEnabled(value: boolean | cdktf.IResolvable);
    resetExpressRouteGatewayBypassEnabled(): void;
    get expressRouteGatewayBypassEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _expressRouteGatewayId?;
    get expressRouteGatewayId(): string;
    set expressRouteGatewayId(value: string);
    get expressRouteGatewayIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _routingWeight?;
    get routingWeight(): number;
    set routingWeight(value: number);
    resetRoutingWeight(): void;
    get routingWeightInput(): number | undefined;
    private _routing;
    get routing(): ExpressRouteConnectionRoutingOutputReference;
    putRouting(value: ExpressRouteConnectionRouting): void;
    resetRouting(): void;
    get routingInput(): ExpressRouteConnectionRouting | undefined;
    private _timeouts;
    get timeouts(): ExpressRouteConnectionTimeoutsOutputReference;
    putTimeouts(value: ExpressRouteConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ExpressRouteConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
