import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogzSubAccountTagRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#id LogzSubAccountTagRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#logz_sub_account_id LogzSubAccountTagRule#logz_sub_account_id}
    */
    readonly logzSubAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#send_aad_logs LogzSubAccountTagRule#send_aad_logs}
    */
    readonly sendAadLogs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#send_activity_logs LogzSubAccountTagRule#send_activity_logs}
    */
    readonly sendActivityLogs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#send_subscription_logs LogzSubAccountTagRule#send_subscription_logs}
    */
    readonly sendSubscriptionLogs?: boolean | cdktf.IResolvable;
    /**
    * tag_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#tag_filter LogzSubAccountTagRule#tag_filter}
    */
    readonly tagFilter?: LogzSubAccountTagRuleTagFilter[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#timeouts LogzSubAccountTagRule#timeouts}
    */
    readonly timeouts?: LogzSubAccountTagRuleTimeouts;
}
export interface LogzSubAccountTagRuleTagFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#action LogzSubAccountTagRule#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#name LogzSubAccountTagRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#value LogzSubAccountTagRule#value}
    */
    readonly value?: string;
}
export declare function logzSubAccountTagRuleTagFilterToTerraform(struct?: LogzSubAccountTagRuleTagFilter | cdktf.IResolvable): any;
export declare class LogzSubAccountTagRuleTagFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogzSubAccountTagRuleTagFilter | cdktf.IResolvable | undefined;
    set internalValue(value: LogzSubAccountTagRuleTagFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class LogzSubAccountTagRuleTagFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogzSubAccountTagRuleTagFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogzSubAccountTagRuleTagFilterOutputReference;
}
export interface LogzSubAccountTagRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#create LogzSubAccountTagRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#delete LogzSubAccountTagRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#read LogzSubAccountTagRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule#update LogzSubAccountTagRule#update}
    */
    readonly update?: string;
}
export declare function logzSubAccountTagRuleTimeoutsToTerraform(struct?: LogzSubAccountTagRuleTimeoutsOutputReference | LogzSubAccountTagRuleTimeouts | cdktf.IResolvable): any;
export declare class LogzSubAccountTagRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogzSubAccountTagRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogzSubAccountTagRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule azurerm_logz_sub_account_tag_rule}
*/
export declare class LogzSubAccountTagRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logz_sub_account_tag_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logz_sub_account_tag_rule azurerm_logz_sub_account_tag_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogzSubAccountTagRuleConfig
    */
    constructor(scope: Construct, id: string, config: LogzSubAccountTagRuleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logzSubAccountId?;
    get logzSubAccountId(): string;
    set logzSubAccountId(value: string);
    get logzSubAccountIdInput(): string | undefined;
    private _sendAadLogs?;
    get sendAadLogs(): boolean | cdktf.IResolvable;
    set sendAadLogs(value: boolean | cdktf.IResolvable);
    resetSendAadLogs(): void;
    get sendAadLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _sendActivityLogs?;
    get sendActivityLogs(): boolean | cdktf.IResolvable;
    set sendActivityLogs(value: boolean | cdktf.IResolvable);
    resetSendActivityLogs(): void;
    get sendActivityLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _sendSubscriptionLogs?;
    get sendSubscriptionLogs(): boolean | cdktf.IResolvable;
    set sendSubscriptionLogs(value: boolean | cdktf.IResolvable);
    resetSendSubscriptionLogs(): void;
    get sendSubscriptionLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagFilter;
    get tagFilter(): LogzSubAccountTagRuleTagFilterList;
    putTagFilter(value: LogzSubAccountTagRuleTagFilter[] | cdktf.IResolvable): void;
    resetTagFilter(): void;
    get tagFilterInput(): cdktf.IResolvable | LogzSubAccountTagRuleTagFilter[] | undefined;
    private _timeouts;
    get timeouts(): LogzSubAccountTagRuleTimeoutsOutputReference;
    putTimeouts(value: LogzSubAccountTagRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogzSubAccountTagRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
