import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorActivityLogAlertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#description MonitorActivityLogAlert#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#enabled MonitorActivityLogAlert#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#id MonitorActivityLogAlert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#name MonitorActivityLogAlert#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#resource_group_name MonitorActivityLogAlert#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#scopes MonitorActivityLogAlert#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#tags MonitorActivityLogAlert#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#action MonitorActivityLogAlert#action}
    */
    readonly action?: MonitorActivityLogAlertAction[] | cdktf.IResolvable;
    /**
    * criteria block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#criteria MonitorActivityLogAlert#criteria}
    */
    readonly criteria: MonitorActivityLogAlertCriteria;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#timeouts MonitorActivityLogAlert#timeouts}
    */
    readonly timeouts?: MonitorActivityLogAlertTimeouts;
}
export interface MonitorActivityLogAlertAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#action_group_id MonitorActivityLogAlert#action_group_id}
    */
    readonly actionGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#webhook_properties MonitorActivityLogAlert#webhook_properties}
    */
    readonly webhookProperties?: {
        [key: string]: string;
    };
}
export declare function monitorActivityLogAlertActionToTerraform(struct?: MonitorActivityLogAlertAction | cdktf.IResolvable): any;
export declare class MonitorActivityLogAlertActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActivityLogAlertAction | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActivityLogAlertAction | cdktf.IResolvable | undefined);
    private _actionGroupId?;
    get actionGroupId(): string;
    set actionGroupId(value: string);
    get actionGroupIdInput(): string | undefined;
    private _webhookProperties?;
    get webhookProperties(): {
        [key: string]: string;
    };
    set webhookProperties(value: {
        [key: string]: string;
    });
    resetWebhookProperties(): void;
    get webhookPropertiesInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class MonitorActivityLogAlertActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActivityLogAlertAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActivityLogAlertActionOutputReference;
}
export interface MonitorActivityLogAlertCriteriaResourceHealth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#current MonitorActivityLogAlert#current}
    */
    readonly current?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#previous MonitorActivityLogAlert#previous}
    */
    readonly previous?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#reason MonitorActivityLogAlert#reason}
    */
    readonly reason?: string[];
}
export declare function monitorActivityLogAlertCriteriaResourceHealthToTerraform(struct?: MonitorActivityLogAlertCriteriaResourceHealth | cdktf.IResolvable): any;
export declare class MonitorActivityLogAlertCriteriaResourceHealthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActivityLogAlertCriteriaResourceHealth | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActivityLogAlertCriteriaResourceHealth | cdktf.IResolvable | undefined);
    private _current?;
    get current(): string[];
    set current(value: string[]);
    resetCurrent(): void;
    get currentInput(): string[] | undefined;
    private _previous?;
    get previous(): string[];
    set previous(value: string[]);
    resetPrevious(): void;
    get previousInput(): string[] | undefined;
    private _reason?;
    get reason(): string[];
    set reason(value: string[]);
    resetReason(): void;
    get reasonInput(): string[] | undefined;
}
export declare class MonitorActivityLogAlertCriteriaResourceHealthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActivityLogAlertCriteriaResourceHealth[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActivityLogAlertCriteriaResourceHealthOutputReference;
}
export interface MonitorActivityLogAlertCriteriaServiceHealth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#events MonitorActivityLogAlert#events}
    */
    readonly events?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#locations MonitorActivityLogAlert#locations}
    */
    readonly locations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#services MonitorActivityLogAlert#services}
    */
    readonly services?: string[];
}
export declare function monitorActivityLogAlertCriteriaServiceHealthToTerraform(struct?: MonitorActivityLogAlertCriteriaServiceHealth | cdktf.IResolvable): any;
export declare class MonitorActivityLogAlertCriteriaServiceHealthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActivityLogAlertCriteriaServiceHealth | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActivityLogAlertCriteriaServiceHealth | cdktf.IResolvable | undefined);
    private _events?;
    get events(): string[];
    set events(value: string[]);
    resetEvents(): void;
    get eventsInput(): string[] | undefined;
    private _locations?;
    get locations(): string[];
    set locations(value: string[]);
    resetLocations(): void;
    get locationsInput(): string[] | undefined;
    private _services?;
    get services(): string[];
    set services(value: string[]);
    resetServices(): void;
    get servicesInput(): string[] | undefined;
}
export declare class MonitorActivityLogAlertCriteriaServiceHealthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActivityLogAlertCriteriaServiceHealth[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActivityLogAlertCriteriaServiceHealthOutputReference;
}
export interface MonitorActivityLogAlertCriteria {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#caller MonitorActivityLogAlert#caller}
    */
    readonly caller?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#category MonitorActivityLogAlert#category}
    */
    readonly category: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#level MonitorActivityLogAlert#level}
    */
    readonly level?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#operation_name MonitorActivityLogAlert#operation_name}
    */
    readonly operationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#recommendation_category MonitorActivityLogAlert#recommendation_category}
    */
    readonly recommendationCategory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#recommendation_impact MonitorActivityLogAlert#recommendation_impact}
    */
    readonly recommendationImpact?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#recommendation_type MonitorActivityLogAlert#recommendation_type}
    */
    readonly recommendationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#resource_group MonitorActivityLogAlert#resource_group}
    */
    readonly resourceGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#resource_id MonitorActivityLogAlert#resource_id}
    */
    readonly resourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#resource_provider MonitorActivityLogAlert#resource_provider}
    */
    readonly resourceProvider?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#resource_type MonitorActivityLogAlert#resource_type}
    */
    readonly resourceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#status MonitorActivityLogAlert#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#sub_status MonitorActivityLogAlert#sub_status}
    */
    readonly subStatus?: string;
    /**
    * resource_health block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#resource_health MonitorActivityLogAlert#resource_health}
    */
    readonly resourceHealth?: MonitorActivityLogAlertCriteriaResourceHealth[] | cdktf.IResolvable;
    /**
    * service_health block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#service_health MonitorActivityLogAlert#service_health}
    */
    readonly serviceHealth?: MonitorActivityLogAlertCriteriaServiceHealth[] | cdktf.IResolvable;
}
export declare function monitorActivityLogAlertCriteriaToTerraform(struct?: MonitorActivityLogAlertCriteriaOutputReference | MonitorActivityLogAlertCriteria): any;
export declare class MonitorActivityLogAlertCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActivityLogAlertCriteria | undefined;
    set internalValue(value: MonitorActivityLogAlertCriteria | undefined);
    private _caller?;
    get caller(): string;
    set caller(value: string);
    resetCaller(): void;
    get callerInput(): string | undefined;
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    resetOperationName(): void;
    get operationNameInput(): string | undefined;
    private _recommendationCategory?;
    get recommendationCategory(): string;
    set recommendationCategory(value: string);
    resetRecommendationCategory(): void;
    get recommendationCategoryInput(): string | undefined;
    private _recommendationImpact?;
    get recommendationImpact(): string;
    set recommendationImpact(value: string);
    resetRecommendationImpact(): void;
    get recommendationImpactInput(): string | undefined;
    private _recommendationType?;
    get recommendationType(): string;
    set recommendationType(value: string);
    resetRecommendationType(): void;
    get recommendationTypeInput(): string | undefined;
    private _resourceGroup?;
    get resourceGroup(): string;
    set resourceGroup(value: string);
    resetResourceGroup(): void;
    get resourceGroupInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    resetResourceId(): void;
    get resourceIdInput(): string | undefined;
    private _resourceProvider?;
    get resourceProvider(): string;
    set resourceProvider(value: string);
    resetResourceProvider(): void;
    get resourceProviderInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _subStatus?;
    get subStatus(): string;
    set subStatus(value: string);
    resetSubStatus(): void;
    get subStatusInput(): string | undefined;
    private _resourceHealth;
    get resourceHealth(): MonitorActivityLogAlertCriteriaResourceHealthList;
    putResourceHealth(value: MonitorActivityLogAlertCriteriaResourceHealth[] | cdktf.IResolvable): void;
    resetResourceHealth(): void;
    get resourceHealthInput(): cdktf.IResolvable | MonitorActivityLogAlertCriteriaResourceHealth[] | undefined;
    private _serviceHealth;
    get serviceHealth(): MonitorActivityLogAlertCriteriaServiceHealthList;
    putServiceHealth(value: MonitorActivityLogAlertCriteriaServiceHealth[] | cdktf.IResolvable): void;
    resetServiceHealth(): void;
    get serviceHealthInput(): cdktf.IResolvable | MonitorActivityLogAlertCriteriaServiceHealth[] | undefined;
}
export interface MonitorActivityLogAlertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#create MonitorActivityLogAlert#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#delete MonitorActivityLogAlert#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#read MonitorActivityLogAlert#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert#update MonitorActivityLogAlert#update}
    */
    readonly update?: string;
}
export declare function monitorActivityLogAlertTimeoutsToTerraform(struct?: MonitorActivityLogAlertTimeoutsOutputReference | MonitorActivityLogAlertTimeouts | cdktf.IResolvable): any;
export declare class MonitorActivityLogAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActivityLogAlertTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActivityLogAlertTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert azurerm_monitor_activity_log_alert}
*/
export declare class MonitorActivityLogAlert extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_activity_log_alert";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert azurerm_monitor_activity_log_alert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorActivityLogAlertConfig
    */
    constructor(scope: Construct, id: string, config: MonitorActivityLogAlertConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _action;
    get action(): MonitorActivityLogAlertActionList;
    putAction(value: MonitorActivityLogAlertAction[] | cdktf.IResolvable): void;
    resetAction(): void;
    get actionInput(): cdktf.IResolvable | MonitorActivityLogAlertAction[] | undefined;
    private _criteria;
    get criteria(): MonitorActivityLogAlertCriteriaOutputReference;
    putCriteria(value: MonitorActivityLogAlertCriteria): void;
    get criteriaInput(): MonitorActivityLogAlertCriteria | undefined;
    private _timeouts;
    get timeouts(): MonitorActivityLogAlertTimeoutsOutputReference;
    putTimeouts(value: MonitorActivityLogAlertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorActivityLogAlertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
