import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagerAdminRuleCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#description NetworkManagerAdminRuleCollection#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#id NetworkManagerAdminRuleCollection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#name NetworkManagerAdminRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#network_group_ids NetworkManagerAdminRuleCollection#network_group_ids}
    */
    readonly networkGroupIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#security_admin_configuration_id NetworkManagerAdminRuleCollection#security_admin_configuration_id}
    */
    readonly securityAdminConfigurationId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#timeouts NetworkManagerAdminRuleCollection#timeouts}
    */
    readonly timeouts?: NetworkManagerAdminRuleCollectionTimeouts;
}
export interface NetworkManagerAdminRuleCollectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#create NetworkManagerAdminRuleCollection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#delete NetworkManagerAdminRuleCollection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#read NetworkManagerAdminRuleCollection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection#update NetworkManagerAdminRuleCollection#update}
    */
    readonly update?: string;
}
export declare function networkManagerAdminRuleCollectionTimeoutsToTerraform(struct?: NetworkManagerAdminRuleCollectionTimeoutsOutputReference | NetworkManagerAdminRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare class NetworkManagerAdminRuleCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerAdminRuleCollectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerAdminRuleCollectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection azurerm_network_manager_admin_rule_collection}
*/
export declare class NetworkManagerAdminRuleCollection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_manager_admin_rule_collection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager_admin_rule_collection azurerm_network_manager_admin_rule_collection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkManagerAdminRuleCollectionConfig
    */
    constructor(scope: Construct, id: string, config: NetworkManagerAdminRuleCollectionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkGroupIds?;
    get networkGroupIds(): string[];
    set networkGroupIds(value: string[]);
    get networkGroupIdsInput(): string[] | undefined;
    private _securityAdminConfigurationId?;
    get securityAdminConfigurationId(): string;
    set securityAdminConfigurationId(value: string);
    get securityAdminConfigurationIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkManagerAdminRuleCollectionTimeoutsOutputReference;
    putTimeouts(value: NetworkManagerAdminRuleCollectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkManagerAdminRuleCollectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
