import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SearchSharedPrivateLinkServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#id SearchSharedPrivateLinkService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#name SearchSharedPrivateLinkService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#request_message SearchSharedPrivateLinkService#request_message}
    */
    readonly requestMessage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#search_service_id SearchSharedPrivateLinkService#search_service_id}
    */
    readonly searchServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#subresource_name SearchSharedPrivateLinkService#subresource_name}
    */
    readonly subresourceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#target_resource_id SearchSharedPrivateLinkService#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#timeouts SearchSharedPrivateLinkService#timeouts}
    */
    readonly timeouts?: SearchSharedPrivateLinkServiceTimeouts;
}
export interface SearchSharedPrivateLinkServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#create SearchSharedPrivateLinkService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#delete SearchSharedPrivateLinkService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#read SearchSharedPrivateLinkService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service#update SearchSharedPrivateLinkService#update}
    */
    readonly update?: string;
}
export declare function searchSharedPrivateLinkServiceTimeoutsToTerraform(struct?: SearchSharedPrivateLinkServiceTimeoutsOutputReference | SearchSharedPrivateLinkServiceTimeouts | cdktf.IResolvable): any;
export declare class SearchSharedPrivateLinkServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SearchSharedPrivateLinkServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SearchSharedPrivateLinkServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service azurerm_search_shared_private_link_service}
*/
export declare class SearchSharedPrivateLinkService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_search_shared_private_link_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/search_shared_private_link_service azurerm_search_shared_private_link_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SearchSharedPrivateLinkServiceConfig
    */
    constructor(scope: Construct, id: string, config: SearchSharedPrivateLinkServiceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _requestMessage?;
    get requestMessage(): string;
    set requestMessage(value: string);
    resetRequestMessage(): void;
    get requestMessageInput(): string | undefined;
    private _searchServiceId?;
    get searchServiceId(): string;
    set searchServiceId(value: string);
    get searchServiceIdInput(): string | undefined;
    get status(): string;
    private _subresourceName?;
    get subresourceName(): string;
    set subresourceName(value: string);
    get subresourceNameInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SearchSharedPrivateLinkServiceTimeoutsOutputReference;
    putTimeouts(value: SearchSharedPrivateLinkServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SearchSharedPrivateLinkServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
