import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelDataConnectorOffice365ProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project#id SentinelDataConnectorOffice365Project#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project#log_analytics_workspace_id SentinelDataConnectorOffice365Project#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project#name SentinelDataConnectorOffice365Project#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project#tenant_id SentinelDataConnectorOffice365Project#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project#timeouts SentinelDataConnectorOffice365Project#timeouts}
    */
    readonly timeouts?: SentinelDataConnectorOffice365ProjectTimeouts;
}
export interface SentinelDataConnectorOffice365ProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project#create SentinelDataConnectorOffice365Project#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project#delete SentinelDataConnectorOffice365Project#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project#read SentinelDataConnectorOffice365Project#read}
    */
    readonly read?: string;
}
export declare function sentinelDataConnectorOffice365ProjectTimeoutsToTerraform(struct?: SentinelDataConnectorOffice365ProjectTimeoutsOutputReference | SentinelDataConnectorOffice365ProjectTimeouts | cdktf.IResolvable): any;
export declare class SentinelDataConnectorOffice365ProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelDataConnectorOffice365ProjectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelDataConnectorOffice365ProjectTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project azurerm_sentinel_data_connector_office_365_project}
*/
export declare class SentinelDataConnectorOffice365Project extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_data_connector_office_365_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_365_project azurerm_sentinel_data_connector_office_365_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelDataConnectorOffice365ProjectConfig
    */
    constructor(scope: Construct, id: string, config: SentinelDataConnectorOffice365ProjectConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SentinelDataConnectorOffice365ProjectTimeoutsOutputReference;
    putTimeouts(value: SentinelDataConnectorOffice365ProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelDataConnectorOffice365ProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
