import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamAnalyticsOutputFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#api_key StreamAnalyticsOutputFunction#api_key}
    */
    readonly apiKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#batch_max_count StreamAnalyticsOutputFunction#batch_max_count}
    */
    readonly batchMaxCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#batch_max_in_bytes StreamAnalyticsOutputFunction#batch_max_in_bytes}
    */
    readonly batchMaxInBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#function_app StreamAnalyticsOutputFunction#function_app}
    */
    readonly functionApp: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#function_name StreamAnalyticsOutputFunction#function_name}
    */
    readonly functionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#id StreamAnalyticsOutputFunction#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#name StreamAnalyticsOutputFunction#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#resource_group_name StreamAnalyticsOutputFunction#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#stream_analytics_job_name StreamAnalyticsOutputFunction#stream_analytics_job_name}
    */
    readonly streamAnalyticsJobName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#timeouts StreamAnalyticsOutputFunction#timeouts}
    */
    readonly timeouts?: StreamAnalyticsOutputFunctionTimeouts;
}
export interface StreamAnalyticsOutputFunctionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#create StreamAnalyticsOutputFunction#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#delete StreamAnalyticsOutputFunction#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#read StreamAnalyticsOutputFunction#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function#update StreamAnalyticsOutputFunction#update}
    */
    readonly update?: string;
}
export declare function streamAnalyticsOutputFunctionTimeoutsToTerraform(struct?: StreamAnalyticsOutputFunctionTimeoutsOutputReference | StreamAnalyticsOutputFunctionTimeouts | cdktf.IResolvable): any;
export declare class StreamAnalyticsOutputFunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsOutputFunctionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StreamAnalyticsOutputFunctionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function azurerm_stream_analytics_output_function}
*/
export declare class StreamAnalyticsOutputFunction extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stream_analytics_output_function";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_function azurerm_stream_analytics_output_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamAnalyticsOutputFunctionConfig
    */
    constructor(scope: Construct, id: string, config: StreamAnalyticsOutputFunctionConfig);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
    private _batchMaxCount?;
    get batchMaxCount(): number;
    set batchMaxCount(value: number);
    resetBatchMaxCount(): void;
    get batchMaxCountInput(): number | undefined;
    private _batchMaxInBytes?;
    get batchMaxInBytes(): number;
    set batchMaxInBytes(value: number);
    resetBatchMaxInBytes(): void;
    get batchMaxInBytesInput(): number | undefined;
    private _functionApp?;
    get functionApp(): string;
    set functionApp(value: string);
    get functionAppInput(): string | undefined;
    private _functionName?;
    get functionName(): string;
    set functionName(value: string);
    get functionNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _streamAnalyticsJobName?;
    get streamAnalyticsJobName(): string;
    set streamAnalyticsJobName(value: string);
    get streamAnalyticsJobNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): StreamAnalyticsOutputFunctionTimeoutsOutputReference;
    putTimeouts(value: StreamAnalyticsOutputFunctionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StreamAnalyticsOutputFunctionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
