/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.distro;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dflib.jjava.distro.Env;
import org.dflib.jjava.jupyter.channels.JupyterConnection;
import org.dflib.jjava.jupyter.kernel.KernelConnectionProperties;
import org.dflib.jjava.kernel.JavaKernel;
import org.dflib.jjava.kernel.magics.ClasspathMagic;
import org.dflib.jjava.kernel.magics.JarsMagic;
import org.dflib.jjava.kernel.magics.LoadCodeMagic;
import org.dflib.jjava.kernel.magics.TimeMagic;
import org.dflib.jjava.maven.MavenDependencyResolver;
import org.dflib.jjava.maven.magics.AddMavenDependencyMagic;
import org.dflib.jjava.maven.magics.LoadFromPomCellMagic;
import org.dflib.jjava.maven.magics.LoadFromPomLineMagic;
import org.dflib.jjava.maven.magics.MavenMagic;
import org.dflib.jjava.maven.magics.MavenRepoMagic;

public class JJava {
    private static final String JUL_JUPYTER_LOG_FORMAT = "[%4$.1s %1$tF %1$tT.%1$tL %3$s] %5$s%n";
    private static final String POM_PROPERTIES = "META-INF/maven/org.dflib.jjava/jjava-distro/pom.properties";

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Missing connection file argument");
        }
        Path connectionFile = Paths.get(args[0], new String[0]);
        if (!Files.isRegularFile(connectionFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Connection file '" + String.valueOf(connectionFile) + "' isn't a file.");
        }
        System.setProperty("java.util.logging.SimpleFormatter.format", JUL_JUPYTER_LOG_FORMAT);
        KernelConnectionProperties connProps = KernelConnectionProperties.parse(Files.readString(connectionFile));
        JupyterConnection connection = new JupyterConnection(connProps);
        MavenDependencyResolver mavenResolver = new MavenDependencyResolver();
        Properties pomProps = JJava.loadPomProps();
        TimeMagic timeMagic = new TimeMagic();
        Timeout timeout = Timeout.parseOrDefault(System.getenv("JJAVA_TIMEOUT"));
        JavaKernel kernel = ((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)((JavaKernel.Builder)JavaKernel.builder().name("JJava")).version((String)pomProps.getOrDefault((Object)"version", ""))).extensionsEnabled(Env.extensionsEnabled())).compilerOpts(Env.compilerOpts())).timeout(timeout.time, timeout.timeUnit)).lineMagic("load", new LoadCodeMagic("", ".jsh", ".jshell", ".java", ".jjava"))).lineMagic("classpath", new ClasspathMagic())).lineMagic("time", timeMagic)).lineMagic("maven", new MavenMagic(mavenResolver))).lineMagic("mavenRepo", new MavenRepoMagic(mavenResolver))).lineMagic("loadFromPOM", new LoadFromPomLineMagic(mavenResolver))).lineMagic("jars", new JarsMagic())).lineMagic("addMavenDependency", new AddMavenDependencyMagic(mavenResolver))).cellMagic("loadFromPOM", new LoadFromPomCellMagic(mavenResolver))).cellMagic("time", timeMagic)).build();
        kernel.onStartup();
        kernel.addToClasspath(Env.extraClasspath());
        Env.startupSnippets().forEach(s -> kernel.evalBuilder((String)s).resolveMagics().eval());
        kernel.becomeHandlerForConnection(connection);
        connection.connect();
        connection.waitUntilClose();
    }

    private static Properties loadPomProps() {
        Properties properties;
        Properties props = new Properties();
        InputStream in = JJava.class.getClassLoader().getResourceAsStream(POM_PROPERTIES);
        if (in == null) {
            return props;
        }
        try {
            props.load(in);
            properties = props;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading project properties");
            }
        }
        in.close();
        return properties;
    }

    private static class Timeout {
        private static final Pattern TIMEOUT_PATTERN = Pattern.compile("^(?<dur>-?\\d+)\\W*(?<unit>[A-Za-z]+)?$");
        final long time;
        final TimeUnit timeUnit;

        static Timeout parseOrDefault(String value) {
            if (value == null) {
                return new Timeout(-1L, TimeUnit.MILLISECONDS);
            }
            Matcher m = TIMEOUT_PATTERN.matcher(value);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid timeout string: " + value);
            }
            long timeout = Long.parseLong(m.group("dur"));
            TimeUnit unit = TimeUnit.MILLISECONDS;
            if (m.group("unit") != null) {
                try {
                    unit = TimeUnit.valueOf(m.group("unit").toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid timeout unit: " + m.group("unit"));
                }
            }
            return new Timeout(timeout, unit);
        }

        public Timeout(long time, TimeUnit timeUnit) {
            this.time = time;
            this.timeUnit = timeUnit;
        }
    }
}

