/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.channels;

import java.util.ArrayDeque;
import java.util.Deque;
import org.dflib.jjava.jupyter.channels.JupyterSocket;
import org.dflib.jjava.jupyter.channels.ReplyEnvironment;
import org.dflib.jjava.jupyter.messages.ContentType;
import org.dflib.jjava.jupyter.messages.Message;
import org.dflib.jjava.jupyter.messages.MessageContext;
import org.dflib.jjava.jupyter.messages.MessageType;
import org.dflib.jjava.jupyter.messages.publish.PublishStatus;
import org.dflib.jjava.jupyter.messages.reply.ErrorReply;

public class DefaultReplyEnvironment
implements ReplyEnvironment {
    private final JupyterSocket shell;
    private final JupyterSocket iopub;
    private final MessageContext context;
    private final Deque<Runnable> deferred;
    private boolean defer;

    public DefaultReplyEnvironment(JupyterSocket shell, JupyterSocket iopub, MessageContext context) {
        this.shell = shell;
        this.iopub = iopub;
        this.context = context;
        this.deferred = new ArrayDeque<Runnable>();
    }

    public JupyterSocket getShell() {
        return this.shell;
    }

    public JupyterSocket getIopub() {
        return this.iopub;
    }

    public MessageContext getContext() {
        return this.context;
    }

    @Override
    public void publish(Message<?> msg) {
        if (this.defer) {
            this.deferred.push(() -> this.iopub.sendMessage(msg));
            this.defer = false;
        } else {
            this.iopub.sendMessage(msg);
        }
    }

    @Override
    public void reply(Message<?> msg) {
        if (this.defer) {
            this.deferred.push(() -> this.shell.sendMessage(msg));
            this.defer = false;
        } else {
            this.shell.sendMessage(msg);
        }
    }

    @Override
    public ReplyEnvironment defer() {
        this.defer = true;
        return this;
    }

    @Override
    public void defer(Runnable action) {
        this.deferred.push(action);
    }

    @Override
    public void resolveDeferrals() {
        if (this.defer) {
            throw new IllegalStateException("Reply environment is in defer mode but a resolution was request.");
        }
        while (!this.deferred.isEmpty()) {
            this.deferred.pop().run();
        }
    }

    @Override
    public <T extends ContentType<T>> void publish(T content) {
        this.publish((T)((Object)new Message<T>(this.context, content.getType(), content)));
    }

    @Override
    public <T extends ContentType<T>> void reply(T content) {
        this.reply((T)((Object)new Message<T>(this.context, content.getType(), content)));
    }

    @Override
    public void replyError(MessageType<?> type, ErrorReply error) {
        this.reply((ContentType)((Object)new Message<ErrorReply>(this.context, type, error)));
    }

    @Override
    public void setStatusBusy() {
        this.publish(PublishStatus.BUSY);
    }

    @Override
    public void setStatusIdle() {
        this.publish(PublishStatus.IDLE);
    }

    @Override
    public void setBusyDeferIdle() {
        this.setStatusBusy();
        this.defer().setStatusIdle();
    }
}

