/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.display.common;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import org.dflib.jjava.jupyter.kernel.display.DisplayData;
import org.dflib.jjava.jupyter.kernel.display.RenderContext;
import org.dflib.jjava.jupyter.kernel.display.Renderer;
import org.dflib.jjava.jupyter.kernel.display.mime.MIMEType;

public class Url {
    public static String EMBED_KEY = "embed";
    public static String HTML_TAG_KEY = "url.html.tag";
    public static String HTML_SRC_ATTR_KEY = "url.html.src-attr";

    public static void registerAll(Renderer renderer) {
        renderer.createRegistration(URL.class).supporting(MIMEType.ANY).register(Url::renderUrl);
        renderer.createRegistration(URLConnection.class).supporting(MIMEType.ANY).register((conn, ctx) -> Url.renderUrl(conn.getURL(), ctx));
    }

    public static void renderUrl(URL url, RenderContext context) {
        if (context.getParameterAsBoolean(EMBED_KEY, false).booleanValue()) {
            try {
                Object content = url.getContent();
                DisplayData rendered = context.getRenderer().render(content, context.getParams());
                context.getOutputContainer().assign(rendered);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            context.renderIfRequested(MIMEType.TEXT_HTML, () -> {
                String tag = context.getParameterAsString(HTML_TAG_KEY, "a");
                String srcAttr = context.getParameterAsString(HTML_SRC_ATTR_KEY, "src");
                return Url.renderHTML(tag, srcAttr, url, Collections.emptyMap());
            });
        }
    }

    private static String renderHTML(String tag, String srcAttr, URL url, Map<String, String> attrs) {
        String encodedUrl;
        try {
            encodedUrl = URLEncoder.encode(url.toExternalForm(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        StringBuilder html = new StringBuilder("<");
        html.append(tag);
        html.append(" ").append(srcAttr).append("=\"").append(encodedUrl).append('\"');
        attrs.forEach((attr, val) -> {
            if (val != null) {
                html.append(" ").append((String)attr).append("=\"").append((String)val).append("\"");
            }
        });
        return html.toString();
    }
}

