/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.display.mime;

import java.util.Locale;
import java.util.Objects;
import org.dflib.jjava.jupyter.kernel.display.mime.MIMETypeParseException;
import org.dflib.jjava.jupyter.kernel.util.CharPredicate;

public class MIMEType {
    private static final CharPredicate RESTRICTED_NAME_CHAR = CharPredicate.builder().inRange('a', 'z').inRange('A', 'Z').inRange('0', '9').match("!#$&-^_").build();
    private static final String WILDCARD = "*";
    public static final MIMEType ANY = new MIMEType("*", null, "*", null);
    public static final MIMEType APPLICATION_XML = MIMEType.parse("application/xml");
    public static final MIMEType APPLICATION_JSON = MIMEType.parse("application/json");
    public static final MIMEType APPLICATION_JAVASCRIPT = MIMEType.parse("application/javascript");
    public static final MIMEType APPLICATION_PDF = MIMEType.parse("application/pdf");
    public static final MIMEType APPLICATION_FASTINFOSET = MIMEType.parse("application/fastinfoset");
    public static final MIMEType APPLICATION_VND_WAP_WBXML = MIMEType.parse("application/vnd.wap.wbxml");
    public static final MIMEType APPLICATION_ZIP = MIMEType.parse("application/zip");
    public static final MIMEType APPLICATION_CBOR = MIMEType.parse("application/cbor");
    public static final MIMEType TEXT_HTML = MIMEType.parse("text/html");
    public static final MIMEType TEXT_MARKDOWN = MIMEType.parse("text/markdown");
    public static final MIMEType TEXT_LATEX = MIMEType.parse("text/latex");
    public static final MIMEType TEXT_PLAIN = MIMEType.parse("text/plain");
    public static final MIMEType TEXT_CSS = MIMEType.parse("text/css");
    public static final MIMEType IMAGE_PNG = MIMEType.parse("image/png");
    public static final MIMEType IMAGE_JPEG = MIMEType.parse("image/jpeg");
    public static final MIMEType IMAGE_GIF = MIMEType.parse("image/gif");
    public static final MIMEType IMAGE_SVG = MIMEType.parse("image/svg+xml");
    private final String group;
    private final String tree;
    private final String subtype;
    private final String suffix;

    public static MIMEType parse(String raw) throws MIMETypeParseException {
        String subtype;
        if (WILDCARD.equals(raw)) {
            return ANY;
        }
        String type = null;
        String tree = null;
        String suffix = null;
        int subtypeStart = 0;
        int pos = -1;
        block7: while (++pos < raw.length()) {
            char c = raw.charAt(pos);
            switch (c) {
                case '+': 
                case '.': {
                    continue block7;
                }
            }
            if (RESTRICTED_NAME_CHAR.test(c)) continue;
            if (c != '/') {
                throw new MIMETypeParseException(raw, pos, String.format("Expected '/' but got %c", Character.valueOf(c)));
            }
            type = raw.substring(0, pos);
            subtypeStart = pos + 1;
            break;
        }
        if (pos == raw.length()) {
            return new MIMEType(raw, null, null, null);
        }
        if (subtypeStart + 1 == raw.length() && raw.charAt(pos + 1) == '*') {
            return new MIMEType(type, null, WILDCARD, null);
        }
        int lastSuffixStartPos = -1;
        block8: while (++pos < raw.length()) {
            char c = raw.charAt(pos);
            switch (c) {
                case '.': {
                    if (tree != null) continue block8;
                    tree = raw.substring(subtypeStart, pos);
                    subtypeStart = pos + 1;
                    continue block8;
                }
                case '+': {
                    lastSuffixStartPos = pos;
                    continue block8;
                }
            }
            if (RESTRICTED_NAME_CHAR.test(c)) continue;
            throw new MIMETypeParseException(raw, pos, String.format("Unexpected char '%c'", Character.valueOf(c)));
        }
        if (lastSuffixStartPos != -1) {
            subtype = raw.substring(subtypeStart, lastSuffixStartPos);
            suffix = raw.substring(lastSuffixStartPos + 1);
        } else {
            subtype = raw.substring(subtypeStart);
        }
        return new MIMEType(type, tree, subtype, suffix);
    }

    public MIMEType(String group, String tree, String subtype, String suffix) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be given.");
        }
        this.group = group.toLowerCase(Locale.ENGLISH);
        this.tree = tree != null ? tree.toLowerCase(Locale.ENGLISH) : null;
        this.subtype = subtype != null ? subtype.toLowerCase(Locale.ENGLISH) : null;
        this.suffix = suffix != null ? suffix.toLowerCase(Locale.ENGLISH) : null;
    }

    public String getGroup() {
        return this.group;
    }

    public String getTree() {
        return this.tree;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean hasTree() {
        return this.tree != null;
    }

    public boolean hasSubtype() {
        return this.subtype != null;
    }

    public boolean hasSuffix() {
        return this.suffix != null;
    }

    public MIMEType withoutSuffix() {
        return !this.hasSuffix() ? this : new MIMEType(this.group, this.tree, this.subtype, null);
    }

    public boolean subtypeIsWildcard() {
        return WILDCARD.equals(this.subtype);
    }

    public boolean isWildcard() {
        return WILDCARD.equals(this.group);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MIMEType mimeType = (MIMEType)o;
        return Objects.equals(this.group, mimeType.group) && Objects.equals(this.tree, mimeType.tree) && Objects.equals(this.subtype, mimeType.subtype) && Objects.equals(this.suffix, mimeType.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.tree, this.subtype, this.suffix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getGroup());
        if (this.hasSubtype()) {
            sb.append('/');
        }
        if (this.hasTree()) {
            sb.append(this.getTree()).append('.');
        }
        if (this.hasSubtype()) {
            sb.append(this.getSubtype());
        }
        if (this.hasSuffix()) {
            sb.append('+').append(this.getSuffix());
        }
        return sb.toString();
    }
}

