/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.messages.request;

import org.dflib.jjava.jupyter.messages.ContentType;
import org.dflib.jjava.jupyter.messages.MessageType;
import org.dflib.jjava.jupyter.messages.RequestType;
import org.dflib.jjava.jupyter.messages.reply.HistoryReply;
import org.dflib.jjava.shaded.com.google.gson.annotations.SerializedName;

public class HistoryRequest
implements ContentType<HistoryRequest>,
RequestType<HistoryReply> {
    public static final MessageType<HistoryRequest> MESSAGE_TYPE = MessageType.HISTORY_REQUEST;
    public static final MessageType<HistoryReply> REPLY_MESSAGE_TYPE = MessageType.HISTORY_REPLY;
    protected final boolean output;
    protected final boolean raw;
    @SerializedName(value="hist_access_type")
    protected final AccessType accessType;

    @Override
    public MessageType<HistoryRequest> getType() {
        return MESSAGE_TYPE;
    }

    @Override
    public MessageType<HistoryReply> getReplyType() {
        return REPLY_MESSAGE_TYPE;
    }

    private HistoryRequest(boolean output, boolean raw, AccessType accessType) {
        this.output = output;
        this.raw = raw;
        this.accessType = accessType;
    }

    public boolean includeOutput() {
        return this.output;
    }

    public boolean useRaw() {
        return this.raw;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public static enum AccessType {
        RANGE,
        TAIL,
        SEARCH;

    }

    public static class Search
    extends HistoryRequest {
        protected final int n;
        protected final String pattern;
        protected final boolean unique;

        public Search(boolean output, boolean raw, int n, String pattern, boolean unique) {
            super(output, raw, AccessType.SEARCH);
            this.n = n;
            this.pattern = pattern;
            this.unique = unique;
        }

        public int getMaxReturnLength() {
            return this.n;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean filterUnique() {
            return this.unique;
        }
    }

    public static class Tail
    extends HistoryRequest {
        protected final int n;

        public Tail(boolean output, boolean raw, int n) {
            super(output, raw, AccessType.TAIL);
            this.n = n;
        }

        public int getMaxReturnLength() {
            return this.n;
        }
    }

    public static class Range
    extends HistoryRequest {
        protected final int session;
        protected final int start;
        protected final int stop;

        public Range(boolean output, boolean raw, int session, int start, int stop) {
            super(output, raw, AccessType.RANGE);
            this.session = session;
            this.start = start;
            this.stop = stop;
        }

        public int getSessionIndex() {
            return this.session;
        }

        public int getStart() {
            return this.start;
        }

        public int getStop() {
            return this.stop;
        }
    }
}

