/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.telemetry;

import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicLong;
import org.dflib.jjava.jupyter.telemetry.TelemetryCollector;

public abstract class WallAndCpuTimeCollector
implements TelemetryCollector<Measure> {
    private final ThreadMXBean threadMXBean;
    private final AtomicLong totalWT;
    private final AtomicLong totalUT;
    private final AtomicLong totalCT;

    public static boolean canMeasureCpuTimes(ThreadMXBean threadMXBean) {
        try {
            return threadMXBean.isCurrentThreadCpuTimeSupported() && threadMXBean.isThreadCpuTimeEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public WallAndCpuTimeCollector(ThreadMXBean threadMXBean) {
        this.threadMXBean = threadMXBean;
        this.totalWT = new AtomicLong();
        this.totalUT = new AtomicLong();
        this.totalCT = new AtomicLong();
    }

    @Override
    public Measure measurementStart() {
        return new Measure(System.nanoTime(), this.threadMXBean.getCurrentThreadUserTime(), this.threadMXBean.getCurrentThreadCpuTime());
    }

    @Override
    public void measurementEnd(Measure m) {
        long wt = System.nanoTime();
        long ut = this.threadMXBean.getCurrentThreadUserTime();
        long ct = this.threadMXBean.getCurrentThreadCpuTime();
        this.totalWT.addAndGet(wt - m.wt);
        if (m.ut != -1L && ut != -1L && m.ct != -1L && ct != -1L) {
            this.totalUT.addAndGet(ut - m.ut);
            this.totalCT.addAndGet(ct - m.ct);
        } else {
            this.totalUT.set(-1L);
            this.totalCT.set(-1L);
        }
    }

    @Override
    public void stop() {
        this.onStop(this.totalWT.get(), this.totalUT.get(), this.totalCT.get());
    }

    protected abstract void onStop(long var1, long var3, long var5);

    public static class Measure {
        final long wt;
        final long ut;
        final long ct;

        public Measure(long wt, long ut, long ct) {
            this.ct = ct;
            this.wt = wt;
            this.ut = ut;
        }
    }
}

