/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.telemetry;

import java.util.concurrent.atomic.AtomicLong;
import org.dflib.jjava.jupyter.telemetry.TelemetryCollector;

public abstract class WallTimeCollector
implements TelemetryCollector<Long> {
    private final AtomicLong totalWallTime = new AtomicLong();

    @Override
    public Long measurementStart() {
        return System.nanoTime();
    }

    @Override
    public void measurementEnd(Long startState) {
        long delta = System.nanoTime() - startState;
        this.totalWallTime.addAndGet(delta);
    }

    @Override
    public void stop() {
        this.onStop(this.totalWallTime.get());
    }

    protected abstract void onStop(long var1);
}

