/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jdk.jshell.DeclarationSnippet;
import jdk.jshell.EvalException;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.UnresolvedReferenceException;
import org.dflib.jjava.jupyter.kernel.BaseKernel;
import org.dflib.jjava.jupyter.kernel.HelpLink;
import org.dflib.jjava.jupyter.kernel.JupyterIO;
import org.dflib.jjava.jupyter.kernel.LanguageInfo;
import org.dflib.jjava.jupyter.kernel.ReplacementOptions;
import org.dflib.jjava.jupyter.kernel.comm.CommManager;
import org.dflib.jjava.jupyter.kernel.display.DisplayData;
import org.dflib.jjava.jupyter.kernel.display.Renderer;
import org.dflib.jjava.jupyter.kernel.history.HistoryManager;
import org.dflib.jjava.jupyter.kernel.magic.MagicTranspiler;
import org.dflib.jjava.jupyter.kernel.magic.MagicsRegistry;
import org.dflib.jjava.jupyter.kernel.magic.MagicsResolver;
import org.dflib.jjava.jupyter.kernel.util.CharPredicate;
import org.dflib.jjava.jupyter.kernel.util.PathsHandler;
import org.dflib.jjava.jupyter.kernel.util.StringStyler;
import org.dflib.jjava.kernel.JavaKernelBuilder;
import org.dflib.jjava.kernel.execution.CodeEvaluator;
import org.dflib.jjava.kernel.execution.CompilationException;
import org.dflib.jjava.kernel.execution.EvaluationInterruptedException;
import org.dflib.jjava.kernel.execution.EvaluationTimeoutException;
import org.dflib.jjava.kernel.execution.IncompleteSourceException;

public class JavaKernel
extends BaseKernel {
    private static final CharPredicate IDENTIFIER_CHAR = CharPredicate.builder().inRange('a', 'z').inRange('A', 'Z').inRange('0', '9').match('_').build();
    private static final CharPredicate WS = CharPredicate.anyOf(" \t\n\r");
    private static final Pattern MAGIC_PATTERN = Pattern.compile("^(%{1,2})([\\w\\-]*)$");
    private final JShell jShell;
    private final CodeEvaluator evaluator;

    public static Builder builder() {
        return new Builder();
    }

    protected JavaKernel(String name, String version, LanguageInfo languageInfo, List<HelpLink> helpLinks, HistoryManager historyManager, JupyterIO io, CommManager commManager, Renderer renderer, MagicsResolver magicsResolver, MagicsRegistry magicsRegistry, boolean extensionsEnabled, StringStyler errorStyler, JShell jShell, CodeEvaluator evaluator) {
        super(name, version, languageInfo, helpLinks, historyManager, io, commManager, renderer, magicsResolver, magicsRegistry, extensionsEnabled, errorStyler);
        this.jShell = jShell;
        this.evaluator = evaluator;
    }

    public void addToClasspath(String classpath) {
        if (classpath == null || classpath.isBlank()) {
            return;
        }
        String classpathResolved = PathsHandler.joinPaths(PathsHandler.splitAndResolveGlobs(classpath));
        this.jShell.addToClasspath(classpathResolved);
        if (this.extensionsEnabled) {
            this.installExtensions(classpathResolved);
        }
    }

    @Override
    protected List<String> formatError(Throwable e) {
        if (e instanceof CompilationException) {
            return this.formatCompilationException((CompilationException)e);
        }
        if (e instanceof IncompleteSourceException) {
            return this.formatIncompleteSourceException((IncompleteSourceException)e);
        }
        if (e instanceof EvalException) {
            return this.formatEvalException((EvalException)e);
        }
        if (e instanceof UnresolvedReferenceException) {
            return this.formatUnresolvedReferenceException((UnresolvedReferenceException)e);
        }
        if (e instanceof EvaluationTimeoutException) {
            return this.formatEvaluationTimeoutException((EvaluationTimeoutException)e);
        }
        if (e instanceof EvaluationInterruptedException) {
            return this.formatEvaluationInterruptedException((EvaluationInterruptedException)e);
        }
        return new ArrayList<String>(super.formatError(e));
    }

    private List<String> formatCompilationException(CompilationException e) {
        List<String> unresolvedDependencies;
        ArrayList<String> fmt = new ArrayList<String>();
        SnippetEvent event = e.getBadSnippetCompilation();
        Snippet snippet = event.snippet();
        this.jShell.diagnostics(snippet).forEach(d -> {
            if (d.getStartPosition() >= 0L && d.getEndPosition() >= 0L) {
                fmt.addAll(this.errorStyler.highlightSubstringLines(snippet.source(), (int)d.getStartPosition(), (int)d.getEndPosition()));
            } else {
                fmt.addAll(this.errorStyler.primaryLines(snippet.source()));
            }
            for (String line : StringStyler.splitLines(d.getMessage(null))) {
                if (line.trim().startsWith("location:")) continue;
                fmt.add(this.errorStyler.secondary(line));
            }
            fmt.add("");
        });
        if (snippet instanceof DeclarationSnippet && !(unresolvedDependencies = this.jShell.unresolvedDependencies((DeclarationSnippet)snippet).collect(Collectors.toList())).isEmpty()) {
            fmt.addAll(this.errorStyler.primaryLines(snippet.source()));
            fmt.add(this.errorStyler.secondary("Unresolved dependencies:"));
            unresolvedDependencies.forEach(dep -> fmt.add(this.errorStyler.secondary("   - " + dep)));
        }
        return fmt;
    }

    private List<String> formatIncompleteSourceException(IncompleteSourceException e) {
        ArrayList<String> fmt = new ArrayList<String>();
        String source = e.getSource();
        fmt.add(this.errorStyler.secondary("Incomplete input:"));
        fmt.addAll(this.errorStyler.primaryLines(source));
        return fmt;
    }

    private List<String> formatEvalException(EvalException e) {
        ArrayList<String> fmt = new ArrayList<String>();
        String evalExceptionClassName = EvalException.class.getName();
        String actualExceptionName = e.getExceptionClassName();
        super.formatError(e).stream().map(line -> line.replace(evalExceptionClassName, actualExceptionName)).forEach(fmt::add);
        return fmt;
    }

    private List<String> formatUnresolvedReferenceException(UnresolvedReferenceException e) {
        ArrayList<String> fmt = new ArrayList<String>();
        DeclarationSnippet snippet = e.getSnippet();
        List<String> unresolvedDependencies = this.jShell.unresolvedDependencies(snippet).collect(Collectors.toList());
        if (!unresolvedDependencies.isEmpty()) {
            fmt.addAll(this.errorStyler.primaryLines(snippet.source()));
            fmt.add(this.errorStyler.secondary("Unresolved dependencies:"));
            unresolvedDependencies.forEach(dep -> fmt.add(this.errorStyler.secondary("   - " + dep)));
        }
        return fmt;
    }

    private List<String> formatEvaluationTimeoutException(EvaluationTimeoutException e) {
        ArrayList<String> fmt = new ArrayList<String>(this.errorStyler.primaryLines(e.getSource()));
        fmt.add(this.errorStyler.secondary(String.format("Evaluation timed out after %d %s.", e.getDuration(), e.getUnit().name().toLowerCase())));
        return fmt;
    }

    private List<String> formatEvaluationInterruptedException(EvaluationInterruptedException e) {
        ArrayList<String> fmt = new ArrayList<String>(this.errorStyler.primaryLines(e.getSource()));
        fmt.add(this.errorStyler.secondary("Evaluation interrupted."));
        return fmt;
    }

    @Override
    protected Object doEval(String source) {
        return this.evaluator.eval(this.jShell, source);
    }

    @Override
    public DisplayData inspect(String code, int at, boolean extraDetail) {
        List<SourceCodeAnalysis.Documentation> documentations;
        while (at + 1 < code.length() && IDENTIFIER_CHAR.test(code.charAt(at + 1))) {
            ++at;
        }
        int parenIdx = at;
        while (parenIdx + 1 < code.length() && WS.test(code.charAt(parenIdx + 1))) {
            ++parenIdx;
        }
        if (parenIdx + 1 < code.length() && code.charAt(parenIdx + 1) == '(') {
            at = parenIdx + 1;
        }
        if ((documentations = this.jShell.sourceCodeAnalysis().documentation(code, at + 1, true)) == null || documentations.isEmpty()) {
            return null;
        }
        DisplayData fmtDocs = new DisplayData(documentations.stream().map(doc -> {
            Object formatted = doc.signature();
            String javadoc = doc.javadoc();
            if (javadoc != null) {
                formatted = (String)formatted + "\n" + javadoc;
            }
            return formatted;
        }).collect(Collectors.joining("\n\n")));
        fmtDocs.putHTML(documentations.stream().map(doc -> {
            Object formatted = doc.signature();
            String javadoc = doc.javadoc();
            if (javadoc != null) {
                formatted = (String)formatted + "<br/>" + javadoc;
            }
            return formatted;
        }).collect(Collectors.joining("<br/><br/>")));
        return fmtDocs;
    }

    @Override
    public ReplacementOptions complete(String code, int at) {
        List<SourceCodeAnalysis.Suggestion> suggestions;
        int[] replaceStart = new int[1];
        int lineStart = code.lastIndexOf(10, at - 1) + 1;
        String line = code.substring(lineStart, at);
        Matcher magicMatcher = MAGIC_PATTERN.matcher(line);
        if (magicMatcher.find()) {
            String percent = magicMatcher.group(1);
            String prefix = magicMatcher.group(2);
            Set<String> magics = percent.equals("%%") ? this.magicsRegistry.getCellMagicNames() : this.magicsRegistry.getLineMagicNames();
            List<String> options = magics.stream().filter(name -> name.startsWith(prefix)).map(name -> percent + name).sorted().collect(Collectors.toList());
            if (!options.isEmpty()) {
                return new ReplacementOptions(options, lineStart, at);
            }
        }
        if ((suggestions = this.jShell.sourceCodeAnalysis().completionSuggestions(code, at, replaceStart)) == null || suggestions.isEmpty()) {
            return null;
        }
        List<String> options = suggestions.stream().sorted((s1, s2) -> s1.matchesType() ? (s2.matchesType() ? 0 : -1) : (s2.matchesType() ? 1 : 0)).map(SourceCodeAnalysis.Suggestion::continuation).distinct().collect(Collectors.toList());
        return new ReplacementOptions(options, replaceStart[0], at);
    }

    @Override
    public String isComplete(String code) {
        return this.evaluator.isComplete(this.jShell.sourceCodeAnalysis(), code);
    }

    @Override
    public void onShutdown(boolean isRestarting) {
        super.onShutdown(isRestarting);
        this.jShell.close();
    }

    @Override
    public void interrupt() {
        this.evaluator.interrupt();
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.evaluator.getClassLoader();
    }

    public JShell getJShell() {
        return this.jShell;
    }

    public CodeEvaluator getEvaluator() {
        return this.evaluator;
    }

    public static class Builder
    extends JavaKernelBuilder<Builder, JavaKernel> {
        private Builder() {
        }

        @Override
        public JavaKernel build() {
            String name = this.buildName();
            Charset jupyterEncoding = this.buildJupyterIOEncoding();
            CodeEvaluator evaluator = this.buildCodeEvaluator(name);
            JShell jShell = this.buildJShell(evaluator);
            LanguageInfo langInfo = this.buildLanguageInfo();
            MagicTranspiler magicTranspiler = this.buildMagicTranspiler();
            return new JavaKernel(name, this.buildVersion(), langInfo, this.buildHelpLinks(), this.buildHistoryManager(), this.buildJupyterIO(jupyterEncoding), this.buildCommManager(), this.buildRenderer(), this.buildMagicsResolver(magicTranspiler), this.buildMagicsRegistry(), this.buildExtensionsEnabled(), this.buildErrorStyler(), jShell, evaluator);
        }

        protected List<HelpLink> buildHelpLinks() {
            return List.of(new HelpLink("Java tutorials", "https://docs.oracle.com/javase/tutorial/"), new HelpLink("JJava homepage", "https://github.com/dflib/jjava"));
        }
    }
}

