/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jdk.jshell.JShell;
import org.dflib.jjava.jupyter.kernel.BaseKernelBuilder;
import org.dflib.jjava.jupyter.kernel.LanguageInfo;
import org.dflib.jjava.jupyter.kernel.magic.MagicTranspiler;
import org.dflib.jjava.jupyter.kernel.magic.MagicsResolver;
import org.dflib.jjava.kernel.JavaKernel;
import org.dflib.jjava.kernel.execution.CodeEvaluator;

public abstract class JavaKernelBuilder<B extends JavaKernelBuilder<B, K>, K extends JavaKernel>
extends BaseKernelBuilder<B, K> {
    protected long timeoutDuration;
    protected TimeUnit timeoutUnit;
    protected final List<String> compilerOpts = new ArrayList<String>();

    protected JavaKernelBuilder() {
    }

    public B compilerOpts(Iterable<String> opts) {
        opts.forEach(this.compilerOpts::add);
        return (B)this;
    }

    public B timeout(long timeoutDuration, TimeUnit timeoutUnit) {
        this.timeoutDuration = timeoutDuration;
        this.timeoutUnit = Objects.requireNonNull(timeoutUnit);
        return (B)this;
    }

    @Override
    public abstract K build();

    protected JShell buildJShell(CodeEvaluator evaluator) {
        return JShell.builder().out(System.out).err(System.err).in(System.in).executionEngine(evaluator.getExecControlProvider(), Map.of()).compilerOptions(this.compilerOpts.toArray(new String[0])).build();
    }

    protected CodeEvaluator buildCodeEvaluator(String name) {
        long timeoutDuration = this.timeoutUnit != null ? this.timeoutDuration : -1L;
        TimeUnit timeoutUnit = this.timeoutUnit != null ? this.timeoutUnit : TimeUnit.MILLISECONDS;
        return new CodeEvaluator(name, timeoutDuration, timeoutUnit);
    }

    protected MagicsResolver buildMagicsResolver(MagicTranspiler transpiler) {
        return this.magicsResolver != null ? this.magicsResolver : new MagicsResolver("(?<=(?:^|=))\\s*%", "%%", transpiler);
    }

    protected LanguageInfo buildLanguageInfo() {
        return new LanguageInfo.Builder("Java").version(Runtime.version().toString()).mimetype("text/x-java-source").fileExtension(".jshell").pygments("java").codemirror("java").build();
    }
}

