/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel.execution;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.SPIResolutionException;
import org.dflib.jjava.jupyter.telemetry.TelemetryCollector;
import org.dflib.jjava.kernel.execution.JJavaLoaderDelegate;

class JJavaExecutionControl
extends DirectExecutionControl {
    private static final String THREAD_NAME_PREFIX = "jjava-exec-" + String.valueOf(ThreadLocalRandom.current().ints(6L, 97, 123).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append)) + "-";
    public static final String EXECUTION_TIMEOUT_NAME = "Execution Timeout";
    public static final String EXECUTION_INTERRUPTED_NAME = "Execution Interrupted";
    private static final AtomicInteger EXECUTOR_THREAD_ID = new AtomicInteger(0);
    private final ExecutorService executor;
    private final long timeoutDuration;
    private final TimeUnit timeoutUnit;
    private final Map<String, Future<Object>> running;
    private final Map<String, Object> results;
    private final JJavaLoaderDelegate loaderDelegate;
    private final ThreadLocal<TelemetryCollector<?>> telemetryCollector;

    public JJavaExecutionControl(JJavaLoaderDelegate loaderDelegate, long timeoutDuration, TimeUnit timeoutUnit) {
        super(loaderDelegate);
        this.loaderDelegate = loaderDelegate;
        this.running = new ConcurrentHashMap<String, Future<Object>>();
        this.results = new ConcurrentHashMap<String, Object>();
        this.timeoutDuration = timeoutDuration;
        this.timeoutUnit = timeoutDuration > 0L ? Objects.requireNonNull(timeoutUnit) : TimeUnit.MILLISECONDS;
        this.executor = Executors.newCachedThreadPool(r -> new Thread(r, THREAD_NAME_PREFIX + EXECUTOR_THREAD_ID.getAndIncrement()));
        this.telemetryCollector = new ThreadLocal();
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    public Object takeResult(String id) {
        Object result = this.results.remove(id);
        if (result == null) {
            throw new IllegalStateException("No result with key: " + id);
        }
        return result;
    }

    public void unloadClass(String className) {
        this.loaderDelegate.unloadClass(className);
    }

    public void interrupt() {
        this.running.forEach((id, f) -> f.cancel(true));
    }

    public void startThreadTelemetryCollection(TelemetryCollector<?> collector) {
        this.telemetryCollector.set(Objects.requireNonNull(collector));
    }

    public void stopThreadTelemetryCollection() {
        TelemetryCollector<?> collector = this.telemetryCollector.get();
        if (collector != null) {
            collector.stop();
            this.telemetryCollector.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String invoke(Method doitMethod) throws Exception {
        Object value;
        String id = UUID.randomUUID().toString();
        TelemetryCollector<?> tc = this.threadTelemetryCollector();
        Object m = tc.measurementStart();
        try {
            value = this.doInvoke(id, doitMethod);
        }
        finally {
            tc.measurementEnd(m);
        }
        this.results.put(id, value);
        return id;
    }

    private Object doInvoke(String id, Method doitMethod) throws Exception {
        Future<Object> task = this.isNestedCall() ? CompletableFuture.completedFuture(doitMethod.invoke(null, new Object[0])) : this.executor.submit(() -> doitMethod.invoke(null, new Object[0]));
        this.running.put(id, task);
        try {
            Object object = this.timeoutDuration > 0L ? task.get(this.timeoutDuration, this.timeoutUnit) : task.get();
            return object;
        }
        catch (CancellationException e) {
            if (this.executor.isShutdown()) {
                throw new ExecutionControl.StoppedException();
            }
            throw new ExecutionControl.UserException("Execution interrupted.", EXECUTION_INTERRUPTED_NAME, e.getStackTrace());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            if (cause == null) {
                throw new ExecutionControl.UserException("null", "Unknown Invocation Exception", e.getStackTrace());
            }
            if (cause instanceof SPIResolutionException) {
                throw new ExecutionControl.ResolutionException(((SPIResolutionException)cause).id(), cause.getStackTrace());
            }
            throw new ExecutionControl.UserException(String.valueOf(cause.getMessage()), cause.getClass().getName(), cause.getStackTrace());
        }
        catch (TimeoutException e) {
            String message = String.format("Execution timed out after configured timeout of %d %s.", this.timeoutDuration, this.timeoutUnit.toString().toLowerCase());
            throw new ExecutionControl.UserException(message, EXECUTION_TIMEOUT_NAME, e.getStackTrace());
        }
        finally {
            this.running.remove(id, task);
        }
    }

    private boolean isNestedCall() {
        return Thread.currentThread().getName().startsWith(THREAD_NAME_PREFIX);
    }

    private TelemetryCollector<?> threadTelemetryCollector() {
        TelemetryCollector<?> tc = this.telemetryCollector.get();
        return tc != null ? tc : TelemetryCollector.DO_NOTHING;
    }

    public String toString() {
        return "JJavaExecutionControl{timeoutTime=" + this.timeoutDuration + ", timeoutUnit=" + String.valueOf((Object)this.timeoutUnit) + "}";
    }
}

