/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel.execution;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.spi.ExecutionControl;
import org.dflib.jjava.jupyter.kernel.util.PathsHandler;

class JJavaLoaderDelegate
implements LoaderDelegate {
    private static final String CLASSPATH_PROPERTY = "java.class.path";
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private final Map<String, byte[]> declaredClasses = new ConcurrentHashMap<String, byte[]>();
    private final Map<String, Class<?>> loadedClasses = new ConcurrentHashMap();
    private final JJavaClassLoader classLoader = new JJavaClassLoader();

    public JJavaLoaderDelegate() {
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException {
        boolean[] installed = new boolean[cbcs.length];
        for (ExecutionControl.ClassBytecodes cbc : cbcs) {
            this.declaredClasses.put(cbc.name(), cbc.bytecodes());
        }
        int i = 0;
        for (ExecutionControl.ClassBytecodes cbc : cbcs) {
            try {
                Class<?> loaderClass = this.classLoader.findClass(cbc.name());
                this.loadedClasses.put(cbc.name(), loaderClass);
            }
            catch (ClassNotFoundException e) {
                throw new ExecutionControl.ClassInstallException("Unable to load class " + cbc.name() + ": " + e.getMessage(), installed);
            }
            installed[i++] = true;
        }
    }

    @Override
    public void classesRedefined(ExecutionControl.ClassBytecodes[] cbcs) {
        for (ExecutionControl.ClassBytecodes cbc : cbcs) {
            this.declaredClasses.put(cbc.name(), cbc.bytecodes());
        }
    }

    @Override
    public void addToClasspath(String path) throws ExecutionControl.InternalException {
        for (String next : PathsHandler.split(path)) {
            try {
                this.classLoader.addURL(Path.of(next, new String[0]).toUri().toURL());
                System.setProperty(CLASSPATH_PROPERTY, System.getProperty(CLASSPATH_PROPERTY) + PATH_SEPARATOR + next);
            }
            catch (MalformedURLException e) {
                throw new ExecutionControl.InternalException("Unable to resolve classpath " + next + ": " + e.getMessage());
            }
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> klass = this.loadedClasses.get(name);
        if (klass == null && this.declaredClasses.containsKey(name)) {
            klass = this.loadClass(name);
        }
        if (klass == null) {
            throw new ClassNotFoundException(name + " not found");
        }
        return klass;
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    public void unloadClass(String name) {
        this.loadedClasses.remove(name);
        this.declaredClasses.remove(name);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    class JJavaClassLoader
    extends URLClassLoader {
        public JJavaClassLoader() {
            super(new URL[0]);
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] data = JJavaLoaderDelegate.this.declaredClasses.get(name);
            if (data == null) {
                return super.findClass(name);
            }
            try {
                return super.defineClass(name, data, 0, data.length, (CodeSource)null);
            }
            catch (LinkageError er) {
                throw new ClassNotFoundException(name, er);
            }
        }
    }
}

