/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel.magics;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.dflib.jjava.jupyter.kernel.magic.LineMagic;
import org.dflib.jjava.jupyter.kernel.magic.MagicsArgs;
import org.dflib.jjava.kernel.JavaKernel;
import org.dflib.jjava.shaded.com.google.gson.Gson;
import org.dflib.jjava.shaded.com.google.gson.GsonBuilder;
import org.dflib.jjava.shaded.com.google.gson.stream.JsonReader;

public class LoadCodeMagic
implements LineMagic<Void, JavaKernel> {
    private static final String NOTEBOOK_EXTENSION = ".ipynb";
    private static final ThreadLocal<Gson> GSON = ThreadLocal.withInitial(() -> new GsonBuilder().create());
    private static final MagicsArgs LOAD_ARGS = MagicsArgs.builder().required("source").onlyKnownFlags().onlyKnownKeywords().build();
    private final String[] fileExtensions;

    public LoadCodeMagic(String ... fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    @Override
    public Void eval(JavaKernel kernel, List<String> args) throws Exception {
        Map<String, List<String>> vals = LOAD_ARGS.parse(args);
        Path sourcePath = Paths.get(vals.get("source").get(0), new String[0]).toAbsolutePath();
        String file = sourcePath.getFileName().toString();
        for (String extension : this.fileExtensions) {
            Path scriptPath = sourcePath.resolveSibling(file + extension);
            if (!Files.isRegularFile(scriptPath, new LinkOption[0])) continue;
            if (scriptPath.getFileName().endsWith(NOTEBOOK_EXTENSION)) {
                this.execNotebook(kernel, scriptPath);
            } else {
                String source = Files.readString(scriptPath);
                kernel.evalBuilder(source).resolveMagics().eval();
            }
            return null;
        }
        String exts = String.join((CharSequence)", ", this.fileExtensions);
        throw new FileNotFoundException("Could not find any source at '" + String.valueOf(sourcePath) + "'. Also tried with extensions: [" + exts + "].");
    }

    private void execNotebook(JavaKernel kernel, Path notebookPath) throws Exception {
        try (BufferedReader in = Files.newBufferedReader(notebookPath, StandardCharsets.UTF_8);){
            JsonReader reader = GSON.get().newJsonReader(in);
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (!name.equals("cells")) {
                    reader.skipValue();
                    continue;
                }
                reader.beginArray();
                while (reader.hasNext()) {
                    Boolean isCode = null;
                    String source = null;
                    reader.beginObject();
                    block15: while (reader.hasNext()) {
                        if (isCode != null && !isCode.booleanValue()) {
                            reader.skipValue();
                            continue;
                        }
                        switch (reader.nextName()) {
                            case "cell_type": {
                                String cellType = reader.nextString();
                                isCode = cellType.equals("code");
                                continue block15;
                            }
                            case "source": {
                                StringBuilder srcBuilder = new StringBuilder();
                                reader.beginArray();
                                while (reader.hasNext()) {
                                    srcBuilder.append(reader.nextString());
                                }
                                reader.endArray();
                                source = srcBuilder.toString();
                                continue block15;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    if (isCode == null || !isCode.booleanValue()) continue;
                    kernel.evalBuilder(source).resolveMagics().eval();
                }
                reader.endArray();
            }
            reader.endObject();
        }
    }
}

