/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto;

import java.security.SecureRandom;
import org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto.curve25519;
import org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto.hsalsa20;
import org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto.xsalsa20;
import org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto.xsalsa20poly1305;

public class curve25519xsalsa20poly1305 {
    public static final int crypto_secretbox_PUBLICKEYBYTES = 32;
    public static final int crypto_secretbox_SECRETKEYBYTES = 32;
    public static final int crypto_secretbox_BEFORENMBYTES = 32;
    public static final int crypto_secretbox_NONCEBYTES = 24;
    public static final int crypto_secretbox_ZEROBYTES = 32;
    public static final int crypto_secretbox_BOXZEROBYTES = 16;

    public static int crypto_box_getpublickey(byte[] pk, byte[] sk) {
        return curve25519.crypto_scalarmult_base(pk, sk);
    }

    public static int crypto_box_keypair(byte[] pk, byte[] sk) {
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(sk);
        return curve25519.crypto_scalarmult_base(pk, sk);
    }

    public static int crypto_box_afternm(byte[] c, byte[] m, long mlen, byte[] n, byte[] k) {
        return xsalsa20poly1305.crypto_secretbox(c, m, mlen, n, k);
    }

    public static int crypto_box_beforenm(byte[] k, byte[] pk, byte[] sk) {
        byte[] sp = new byte[32];
        byte[] sigmap = xsalsa20.sigma;
        curve25519.crypto_scalarmult(sp, sk, pk);
        return hsalsa20.crypto_core(k, null, sp, sigmap);
    }

    public static int crypto_box(byte[] c, byte[] m, long mlen, byte[] n, byte[] pk, byte[] sk) {
        byte[] kp = new byte[32];
        curve25519xsalsa20poly1305.crypto_box_beforenm(kp, pk, sk);
        return curve25519xsalsa20poly1305.crypto_box_afternm(c, m, mlen, n, kp);
    }

    public static int crypto_box_open(byte[] m, byte[] c, long clen, byte[] n, byte[] pk, byte[] sk) {
        byte[] kp = new byte[32];
        curve25519xsalsa20poly1305.crypto_box_beforenm(kp, pk, sk);
        return curve25519xsalsa20poly1305.crypto_box_open_afternm(m, c, clen, n, kp);
    }

    public static int crypto_box_open_afternm(byte[] m, byte[] c, long clen, byte[] n, byte[] k) {
        return xsalsa20poly1305.crypto_secretbox_open(m, c, clen, n, k);
    }

    public static int crypto_box_afternm(byte[] c, byte[] m, byte[] n, byte[] k) {
        return curve25519xsalsa20poly1305.crypto_box_afternm(c, m, m.length, n, k);
    }

    public static int crypto_box_open_afternm(byte[] m, byte[] c, byte[] n, byte[] k) {
        return curve25519xsalsa20poly1305.crypto_box_open_afternm(m, c, c.length, n, k);
    }

    public static int crypto_box(byte[] c, byte[] m, byte[] n, byte[] pk, byte[] sk) {
        return curve25519xsalsa20poly1305.crypto_box(c, m, m.length, n, pk, sk);
    }

    public static int crypto_box_open(byte[] m, byte[] c, byte[] n, byte[] pk, byte[] sk) {
        return curve25519xsalsa20poly1305.crypto_box_open(m, c, c.length, n, pk, sk);
    }
}

