/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto;

import org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto.verify_16;

public class poly1305 {
    final int CRYPTO_BYTES = 16;
    final int CRYPTO_KEYBYTES = 32;
    static final int[] minusp = new int[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252};

    public static int crypto_onetimeauth_verify(byte[] h, int hoffset, byte[] inv, int invoffset, long inlen, byte[] k) {
        byte[] correct = new byte[16];
        poly1305.crypto_onetimeauth(correct, 0, inv, invoffset, inlen, k);
        return verify_16.crypto_verify(h, hoffset, correct);
    }

    static void add(int[] h, int[] c) {
        int u = 0;
        for (int j = 0; j < 17; ++j) {
            h[j] = (u += h[j] + c[j]) & 0xFF;
            u >>>= 8;
        }
    }

    static void squeeze(int[] h) {
        int j;
        int u = 0;
        for (j = 0; j < 16; ++j) {
            h[j] = (u += h[j]) & 0xFF;
            u >>>= 8;
        }
        h[16] = (u += h[16]) & 3;
        u = 5 * (u >>> 2);
        for (j = 0; j < 16; ++j) {
            h[j] = (u += h[j]) & 0xFF;
            u >>>= 8;
        }
        h[16] = u += h[16];
    }

    static void freeze(int[] h) {
        int[] horig = new int[17];
        for (int j = 0; j < 17; ++j) {
            horig[j] = h[j];
        }
        poly1305.add(h, minusp);
        int negative = -(h[16] >>> 7);
        for (int j = 0; j < 17; ++j) {
            int n = j;
            h[n] = h[n] ^ negative & (horig[j] ^ h[j]);
        }
    }

    static void mulmod(int[] h, int[] r) {
        int i;
        int[] hr = new int[17];
        for (i = 0; i < 17; ++i) {
            int j;
            int u = 0;
            for (j = 0; j <= i; ++j) {
                u += h[j] * r[i - j];
            }
            for (j = i + 1; j < 17; ++j) {
                u += 320 * h[j] * r[i + 17 - j];
            }
            hr[i] = u;
        }
        for (i = 0; i < 17; ++i) {
            h[i] = hr[i];
        }
        poly1305.squeeze(h);
    }

    public static int crypto_onetimeauth(byte[] outv, int outvoffset, byte[] inv, int invoffset, long inlen, byte[] k) {
        int j;
        int[] r = new int[17];
        int[] h = new int[17];
        int[] c = new int[17];
        r[0] = k[0] & 0xFF;
        r[1] = k[1] & 0xFF;
        r[2] = k[2] & 0xFF;
        r[3] = k[3] & 0xF;
        r[4] = k[4] & 0xFC;
        r[5] = k[5] & 0xFF;
        r[6] = k[6] & 0xFF;
        r[7] = k[7] & 0xF;
        r[8] = k[8] & 0xFC;
        r[9] = k[9] & 0xFF;
        r[10] = k[10] & 0xFF;
        r[11] = k[11] & 0xF;
        r[12] = k[12] & 0xFC;
        r[13] = k[13] & 0xFF;
        r[14] = k[14] & 0xFF;
        r[15] = k[15] & 0xF;
        r[16] = 0;
        for (j = 0; j < 17; ++j) {
            h[j] = 0;
        }
        while (inlen > 0L) {
            for (j = 0; j < 17; ++j) {
                c[j] = 0;
            }
            for (j = 0; j < 16 && (long)j < inlen; ++j) {
                c[j] = inv[invoffset + j] & 0xFF;
            }
            c[j] = 1;
            invoffset += j;
            inlen -= (long)j;
            poly1305.add(h, c);
            poly1305.mulmod(h, r);
        }
        poly1305.freeze(h);
        for (j = 0; j < 16; ++j) {
            c[j] = k[j + 16] & 0xFF;
        }
        c[16] = 0;
        poly1305.add(h, c);
        for (j = 0; j < 16; ++j) {
            outv[j + outvoffset] = (byte)h[j];
        }
        return 0;
    }
}

