/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto;

import org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto.poly1305;
import org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto.xsalsa20;

public class xsalsa20poly1305 {
    final int crypto_secretbox_KEYBYTES = 32;
    final int crypto_secretbox_NONCEBYTES = 24;
    final int crypto_secretbox_ZEROBYTES = 32;
    final int crypto_secretbox_BOXZEROBYTES = 16;

    public static int crypto_secretbox(byte[] c, byte[] m, long mlen, byte[] n, byte[] k) {
        if (mlen < 32L) {
            return -1;
        }
        xsalsa20.crypto_stream_xor(c, m, mlen, n, k);
        poly1305.crypto_onetimeauth(c, 16, c, 32, mlen - 32L, c);
        for (int i = 0; i < 16; ++i) {
            c[i] = 0;
        }
        return 0;
    }

    public static int crypto_secretbox_open(byte[] m, byte[] c, long clen, byte[] n, byte[] k) {
        if (clen < 32L) {
            return -1;
        }
        byte[] subkeyp = new byte[32];
        xsalsa20.crypto_stream(subkeyp, 32, n, k);
        if (poly1305.crypto_onetimeauth_verify(c, 16, c, 32, clen - 32L, subkeyp) != 0) {
            return -1;
        }
        xsalsa20.crypto_stream_xor(m, c, clen, n, k);
        for (int i = 0; i < 32; ++i) {
            m[i] = 0;
        }
        return 0;
    }
}

