/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.maven.model.interpolation;

import java.util.Properties;
import org.dflib.jjava.shaded.javax.inject.Named;
import org.dflib.jjava.shaded.javax.inject.Singleton;
import org.dflib.jjava.shaded.org.apache.maven.model.building.ModelBuildingRequest;
import org.dflib.jjava.shaded.org.apache.maven.model.interpolation.ModelVersionProcessor;

@Named
@Singleton
public class DefaultModelVersionProcessor
implements ModelVersionProcessor {
    private static final String SHA1_PROPERTY = "sha1";
    private static final String CHANGELIST_PROPERTY = "changelist";
    private static final String REVISION_PROPERTY = "revision";

    @Override
    public boolean isValidProperty(String property) {
        return REVISION_PROPERTY.equals(property) || CHANGELIST_PROPERTY.equals(property) || SHA1_PROPERTY.equals(property);
    }

    @Override
    public void overwriteModelProperties(Properties modelProperties, ModelBuildingRequest request) {
        if (request.getUserProperties().containsKey(REVISION_PROPERTY)) {
            modelProperties.put(REVISION_PROPERTY, request.getUserProperties().get(REVISION_PROPERTY));
        }
        if (request.getUserProperties().containsKey(CHANGELIST_PROPERTY)) {
            modelProperties.put(CHANGELIST_PROPERTY, request.getUserProperties().get(CHANGELIST_PROPERTY));
        }
        if (request.getUserProperties().containsKey(SHA1_PROPERTY)) {
            modelProperties.put(SHA1_PROPERTY, request.getUserProperties().get(SHA1_PROPERTY));
        }
    }
}

