/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.aether.internal.impl.checksum;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dflib.jjava.shaded.javax.inject.Inject;
import org.dflib.jjava.shaded.javax.inject.Named;
import org.dflib.jjava.shaded.javax.inject.Singleton;
import org.dflib.jjava.shaded.org.eclipse.aether.RepositorySystemSession;
import org.dflib.jjava.shaded.org.eclipse.aether.artifact.Artifact;
import org.dflib.jjava.shaded.org.eclipse.aether.repository.RemoteRepository;
import org.dflib.jjava.shaded.org.eclipse.aether.spi.checksums.ProvidedChecksumsSource;
import org.dflib.jjava.shaded.org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.dflib.jjava.shaded.org.eclipse.aether.spi.connector.ArtifactDownload;
import org.dflib.jjava.shaded.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

@Singleton
@Named(value="trusted2provided")
public final class TrustedToProvidedChecksumsSourceAdapter
implements ProvidedChecksumsSource {
    public static final String NAME = "trusted2provided";
    private final Map<String, TrustedChecksumsSource> trustedChecksumsSources;

    @Inject
    public TrustedToProvidedChecksumsSourceAdapter(Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        this.trustedChecksumsSources = Objects.requireNonNull(trustedChecksumsSources);
    }

    @Override
    public Map<String, String> getProvidedArtifactChecksums(RepositorySystemSession session, ArtifactDownload transfer, RemoteRepository repository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        Map<String, String> trustedChecksums;
        Artifact artifact = transfer.getArtifact();
        for (TrustedChecksumsSource trustedChecksumsSource : this.trustedChecksumsSources.values()) {
            trustedChecksums = trustedChecksumsSource.getTrustedArtifactChecksums(session, artifact, repository, checksumAlgorithmFactories);
            if (trustedChecksums == null || trustedChecksums.isEmpty()) continue;
            return trustedChecksums;
        }
        if (!transfer.getRepositories().isEmpty()) {
            for (RemoteRepository remoteRepository : transfer.getRepositories()) {
                for (TrustedChecksumsSource trustedChecksumsSource : this.trustedChecksumsSources.values()) {
                    trustedChecksums = trustedChecksumsSource.getTrustedArtifactChecksums(session, artifact, remoteRepository, checksumAlgorithmFactories);
                    if (trustedChecksums == null || trustedChecksums.isEmpty()) continue;
                    return trustedChecksums;
                }
            }
        }
        return null;
    }
}

