/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.aether.util.graph.selector;

import java.util.Objects;
import org.dflib.jjava.shaded.org.eclipse.aether.collection.DependencyCollectionContext;
import org.dflib.jjava.shaded.org.eclipse.aether.collection.DependencySelector;
import org.dflib.jjava.shaded.org.eclipse.aether.graph.Dependency;

public final class OptionalDependencySelector
implements DependencySelector {
    private final int depth;

    public OptionalDependencySelector() {
        this.depth = 0;
    }

    private OptionalDependencySelector(int depth) {
        this.depth = depth;
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency cannot be null");
        return this.depth < 2 || !dependency.isOptional();
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        if (this.depth >= 2) {
            return this;
        }
        return new OptionalDependencySelector(this.depth + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        OptionalDependencySelector that = (OptionalDependencySelector)obj;
        return this.depth == that.depth;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + this.depth;
        return hash;
    }

    public String toString() {
        return String.format("%s(depth: %d)", this.getClass().getSimpleName(), this.depth);
    }
}

