/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.aether.util.listener;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dflib.jjava.shaded.org.eclipse.aether.AbstractRepositoryListener;
import org.dflib.jjava.shaded.org.eclipse.aether.RepositoryEvent;
import org.dflib.jjava.shaded.org.eclipse.aether.RepositoryListener;

public final class ChainedRepositoryListener
extends AbstractRepositoryListener {
    private final List<RepositoryListener> listeners = new CopyOnWriteArrayList<RepositoryListener>();

    public static RepositoryListener newInstance(RepositoryListener listener1, RepositoryListener listener2) {
        if (listener1 == null) {
            return listener2;
        }
        if (listener2 == null) {
            return listener1;
        }
        return new ChainedRepositoryListener(listener1, listener2);
    }

    public ChainedRepositoryListener(RepositoryListener ... listeners) {
        if (listeners != null) {
            this.add(Arrays.asList(listeners));
        }
    }

    public ChainedRepositoryListener(Collection<? extends RepositoryListener> listeners) {
        this.add(listeners);
    }

    public void add(Collection<? extends RepositoryListener> listeners) {
        if (listeners != null) {
            for (RepositoryListener repositoryListener : listeners) {
                this.add(repositoryListener);
            }
        }
    }

    public void add(RepositoryListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void remove(RepositoryListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void handleError(RepositoryEvent event, RepositoryListener listener, RuntimeException error) {
    }

    @Override
    public void artifactDeployed(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDeployed(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactDeploying(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDeploying(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDescriptorInvalid(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDescriptorMissing(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactDownloaded(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDownloaded(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactDownloading(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDownloading(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactInstalled(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactInstalled(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactInstalling(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactInstalling(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactResolved(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactResolved(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void artifactResolving(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactResolving(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataDeployed(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataDeployed(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataDeploying(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataDeploying(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataDownloaded(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataDownloaded(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataDownloading(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataDownloading(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataInstalled(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataInstalled(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataInstalling(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataInstalling(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataInvalid(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataResolved(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataResolved(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }

    @Override
    public void metadataResolving(RepositoryEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataResolving(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener, e);
            }
        }
    }
}

