/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.sisu.inject;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class MildKeys<K, V>
implements Map<K, V> {
    final ReferenceQueue<K> queue = new ReferenceQueue();
    final Map<Reference<K>, V> map;
    private final boolean soft;

    MildKeys(Map<Reference<K>, V> map, boolean soft) {
        this.map = map;
        this.soft = soft;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.map.containsKey(MildKeys.tempKey(key));
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public final V get(Object key) {
        return this.map.get(MildKeys.tempKey(key));
    }

    @Override
    public final V put(K key, V value) {
        this.compact();
        return this.map.put(this.mildKey(key), value);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.compact();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.map.put(this.mildKey(e.getKey()), e.getValue());
        }
    }

    @Override
    public final V remove(Object key) {
        this.compact();
        return this.map.remove(MildKeys.tempKey(key));
    }

    @Override
    public final void clear() {
        this.map.clear();
        this.compact();
    }

    @Override
    public final boolean isEmpty() {
        this.compact();
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        this.compact();
        return this.map.size();
    }

    @Override
    public final Set<K> keySet() {
        this.compact();
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyItr();
            }

            @Override
            public int size() {
                return MildKeys.this.map.size();
            }
        };
    }

    @Override
    public final Collection<V> values() {
        this.compact();
        return this.map.values();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        this.compact();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryItr();
            }

            @Override
            public int size() {
                return MildKeys.this.map.size();
            }
        };
    }

    final Reference<K> mildKey(K key) {
        return this.soft ? new Soft<K>(key, this.queue) : new Weak<K>(key, this.queue);
    }

    static final <K> Reference<K> tempKey(K key) {
        return new Weak<K>(key, null);
    }

    final void compact() {
        Reference<K> ref;
        while ((ref = this.queue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    static class Soft<T>
    extends SoftReference<T> {
        private final int hash;

        Soft(T o, ReferenceQueue<T> queue) {
            super(o, queue);
            this.hash = o.hashCode();
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            Object o = this.get();
            if (null != o && rhs instanceof Reference) {
                return o == ((Reference)rhs).get();
            }
            return false;
        }
    }

    static class Weak<T>
    extends WeakReference<T> {
        private final int hash;

        Weak(T o, ReferenceQueue<T> queue) {
            super(o, queue);
            this.hash = o.hashCode();
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            Object o = this.get();
            if (null != o && rhs instanceof Reference) {
                return o == ((Reference)rhs).get();
            }
            return false;
        }
    }

    final class StrongEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<Reference<K>, V> entry;
        private final K key;

        StrongEntry(Map.Entry<Reference<K>, V> entry, K key) {
            this.entry = entry;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }
    }

    final class EntryItr
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Reference<K>, V>> itr;
        private Map.Entry<Reference<K>, V> nextEntry;
        private K nextKey;

        EntryItr() {
            this.itr = MildKeys.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (null == this.nextKey && this.itr.hasNext()) {
                this.nextEntry = this.itr.next();
                this.nextKey = this.nextEntry.getKey().get();
            }
            return null != this.nextKey;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.hasNext()) {
                StrongEntry entry = new StrongEntry(this.nextEntry, this.nextKey);
                this.nextEntry = null;
                this.nextKey = null;
                return entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    final class KeyItr
    implements Iterator<K> {
        private final Iterator<Reference<K>> itr;
        private K nextKey;

        KeyItr() {
            this.itr = MildKeys.this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (null == this.nextKey && this.itr.hasNext()) {
                this.nextKey = this.itr.next().get();
            }
            return null != this.nextKey;
        }

        @Override
        public K next() {
            if (this.hasNext()) {
                Object key = this.nextKey;
                this.nextKey = null;
                return key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

