/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.sisu.launch;

import java.util.Collections;
import java.util.Map;
import org.dflib.jjava.shaded.com.google.inject.Binder;
import org.dflib.jjava.shaded.com.google.inject.Guice;
import org.dflib.jjava.shaded.com.google.inject.Injector;
import org.dflib.jjava.shaded.com.google.inject.Module;
import org.dflib.jjava.shaded.com.google.inject.Provides;
import org.dflib.jjava.shaded.javax.inject.Inject;
import org.dflib.jjava.shaded.org.eclipse.sisu.Parameters;
import org.dflib.jjava.shaded.org.eclipse.sisu.inject.MutableBeanLocator;
import org.dflib.jjava.shaded.org.eclipse.sisu.space.BeanScanning;
import org.dflib.jjava.shaded.org.eclipse.sisu.space.ClassSpace;
import org.dflib.jjava.shaded.org.eclipse.sisu.space.SpaceModule;
import org.dflib.jjava.shaded.org.eclipse.sisu.space.URLClassSpace;
import org.dflib.jjava.shaded.org.eclipse.sisu.wire.ParameterKeys;
import org.dflib.jjava.shaded.org.eclipse.sisu.wire.WireModule;

public final class Main
implements Module {
    private final Map<?, ?> properties;
    private final String[] args;

    private Main(Map<?, ?> properties, String ... args) {
        this.properties = Collections.unmodifiableMap(properties);
        this.args = args;
    }

    public static void main(String ... args) {
        Main.boot(System.getProperties(), args);
    }

    public static <T> T boot(Class<T> type, String ... args) {
        return (T)Main.boot(System.getProperties(), args).getInstance(type);
    }

    public static <T> T boot(Class<T> type, String[] args, Module ... bindings) {
        return (T)Main.boot(System.getProperties(), args, bindings).getInstance(type);
    }

    public static Injector boot(Map<?, ?> properties, String ... args) {
        return Main.boot(properties, args, new Module[0]);
    }

    public static Injector boot(Map<?, ?> properties, String[] args, Module ... bindings) {
        Module[] modules = new Module[bindings.length + 1];
        System.arraycopy(bindings, 0, modules, 1, bindings.length);
        modules[0] = new Main(properties, args);
        BeanScanning scanning = BeanScanning.select(properties);
        Module app = Main.wire(scanning, modules);
        Injector injector = Guice.createInjector((Module[])new Module[]{app});
        return injector;
    }

    public static Module wire(BeanScanning scanning, Module ... bindings) {
        Module[] modules = new Module[bindings.length + 1];
        System.arraycopy(bindings, 0, modules, 0, bindings.length);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        modules[bindings.length] = new SpaceModule((ClassSpace)new URLClassSpace(tccl), scanning);
        return new WireModule(modules);
    }

    public void configure(Binder binder) {
        binder.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
        binder.bind(ShutdownThread.class).asEagerSingleton();
    }

    @Provides
    @Parameters
    String[] parameters() {
        return (String[])this.args.clone();
    }

    static final class ShutdownThread
    extends Thread {
        private final MutableBeanLocator locator;

        @Inject
        ShutdownThread(MutableBeanLocator locator) {
            this.locator = locator;
            Runtime.getRuntime().addShutdownHook(this);
        }

        @Override
        public void run() {
            this.locator.clear();
        }
    }
}

