/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.zeromq.timer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.dflib.jjava.shaded.org.zeromq.timer.TimerHandler;
import org.dflib.jjava.shaded.zmq.util.Clock;
import org.dflib.jjava.shaded.zmq.util.Utils;
import org.dflib.jjava.shaded.zmq.util.function.Supplier;

public final class ZTicket {
    private final List<Ticket> tickets;
    private final Supplier<Long> clock;
    private boolean sort;

    public ZTicket() {
        this(() -> TimeUnit.NANOSECONDS.toMillis(Clock.nowNS()));
    }

    ZTicket(Supplier<Long> clock) {
        this(clock, new ArrayList<Ticket>());
    }

    ZTicket(Supplier<Long> clock, List<Ticket> tickets) {
        this.clock = clock;
        this.tickets = tickets;
    }

    private long now() {
        return this.clock.get();
    }

    private void insert(Ticket ticket) {
        this.sort = this.tickets.add(ticket);
    }

    public Ticket add(long delay, TimerHandler handler, Object ... args) {
        if (handler == null) {
            return null;
        }
        Utils.checkArgument(delay > 0L, "Delay of a ticket has to be strictly greater than 0");
        Ticket ticket = new Ticket(this, this.now(), delay, handler, args);
        this.insert(ticket);
        return ticket;
    }

    public long timeout() {
        if (this.tickets.isEmpty()) {
            return -1L;
        }
        this.sortIfNeeded();
        Ticket first = this.tickets.get(0);
        long time = first.start - this.now() + first.delay;
        if (time > 0L) {
            return time;
        }
        return 0L;
    }

    public int execute() {
        Ticket ticket2;
        int executed = 0;
        long now = this.now();
        this.sortIfNeeded();
        HashSet<Ticket> cancelled = new HashSet<Ticket>();
        for (Ticket ticket2 : this.tickets) {
            if (now - ticket2.start < ticket2.delay) break;
            if (!ticket2.alive) {
                cancelled.add(ticket2);
                continue;
            }
            ticket2.alive = false;
            cancelled.add(ticket2);
            ticket2.handler.time(ticket2.args);
            ++executed;
        }
        int idx = this.tickets.size();
        while (idx-- > 0 && !(ticket2 = this.tickets.get(idx)).alive) {
            cancelled.add(ticket2);
        }
        this.tickets.removeAll(cancelled);
        cancelled.clear();
        return executed;
    }

    private void sortIfNeeded() {
        if (this.sort) {
            this.sort = false;
            Collections.sort(this.tickets);
        }
    }

    public static final class Ticket
    implements Comparable<Ticket> {
        private final ZTicket parent;
        private final TimerHandler handler;
        private final Object[] args;
        private long start;
        private long delay;
        private boolean alive = true;

        private Ticket(ZTicket parent, long now, long delay, TimerHandler handler, Object ... args) {
            assert (args != null);
            this.parent = parent;
            this.start = now;
            this.delay = delay;
            this.handler = handler;
            this.args = args;
        }

        public void reset() {
            if (this.alive) {
                this.parent.sort = true;
                this.start = this.parent.now();
            }
        }

        public boolean cancel() {
            if (this.alive) {
                this.alive = false;
                this.parent.sort = true;
                return true;
            }
            return false;
        }

        public void setDelay(long delay) {
            if (this.alive) {
                this.parent.sort = true;
                this.delay = delay;
            }
        }

        @Override
        public int compareTo(Ticket other) {
            if (this.alive) {
                if (other.alive) {
                    return Long.compare(this.start - other.start, other.delay - this.delay);
                }
                return -1;
            }
            return other.alive ? 1 : 0;
        }
    }
}

